/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum
implements OracleDatumWithConnection {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Mar_12_20:10:49_PDT_2013";
    public static final boolean TRACE = false;

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
    }

    public DatumWithConnection() {
    }

    public static void assertNotNull(Connection connection) throws SQLException {
        if (connection == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "Connection is null");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        if (typeDescriptor == null) {
            SQLException sQLException = DatabaseError.createSqlException(null, 61);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void setPhysicalConnectionOf(Connection connection) {
        this.physicalConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    @Override
    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    @Override
    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.getPhysicalConnection();
    }

    @Override
    public OracleConnection getConnection() throws SQLException {
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
        }
        catch (ClassCastException classCastException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 103);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return oracleConnection;
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.physicalConnection;
    }
}

