/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Mar_12_20:10:49_PDT_2013";
    public static final boolean TRACE = false;

    public OracleTimeoutPollingThread() {
        super(threadName);
        this.setDaemon(true);
        this.setPriority(10);
        this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
        this.count = 0;
        this.sleepMillis = Long.parseLong(PhysicalConnection.getSystemPropertyPollInterval());
        this.start();
    }

    public synchronized void addTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        int n2 = 0;
        if (this.count >= this.knownTimeouts.length) {
            OracleTimeoutThreadPerVM[] oracleTimeoutThreadPerVMArray = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
            System.arraycopy(this.knownTimeouts, 0, oracleTimeoutThreadPerVMArray, 0, this.knownTimeouts.length);
            n2 = this.knownTimeouts.length;
            this.knownTimeouts = oracleTimeoutThreadPerVMArray;
        }
        while (n2 < this.knownTimeouts.length) {
            if (this.knownTimeouts[n2] == null) {
                this.knownTimeouts[n2] = oracleTimeoutThreadPerVM;
                ++this.count;
                break;
            }
            ++n2;
        }
    }

    public synchronized void removeTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
            if (this.knownTimeouts[i2] != oracleTimeoutThreadPerVM) continue;
            this.knownTimeouts[i2] = null;
            --this.count;
            break;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pollOnce();
        }
    }

    private void pollOnce() {
        if (this.count > 0) {
            long l2 = System.currentTimeMillis();
            for (int i2 = 0; i2 < this.knownTimeouts.length; ++i2) {
                try {
                    if (this.knownTimeouts[i2] == null) continue;
                    this.knownTimeouts[i2].interruptIfAppropriate(l2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }
}

