/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.HashMap;
import java.util.List;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtils;

public class IndexSnapshotGenerator
extends JdbcSnapshotGenerator {
    public IndexSnapshotGenerator() {
        super(Index.class, new Class[]{Table.class, ForeignKey.class, UniqueConstraint.class});
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Index.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            List<CachedRow> rs = null;
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                rs = databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), table.getName(), null);
                HashMap<String, Index> foundIndexes = new HashMap<String, Index>();
                for (CachedRow row : rs) {
                    String ascOrDesc;
                    String indexName = row.getString("INDEX_NAME");
                    if (indexName == null) continue;
                    Index index = (Index)foundIndexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                        short type = row.getShort("TYPE");
                        if (type == 1) {
                            index.setClustered(true);
                        } else if (database instanceof MSSQLDatabase) {
                            index.setClustered(false);
                        }
                        foundIndexes.put(indexName, index);
                    }
                    Boolean descending = "D".equals(ascOrDesc = row.getString("ASC_OR_DESC")) ? Boolean.TRUE : ("A".equals(ascOrDesc) ? Boolean.FALSE : null);
                    index.addColumn(new Column(row.getString("COLUMN_NAME")).setComputed(false).setDescending(descending).setRelation(index.getTable()));
                }
                for (Index exampleIndex : foundIndexes.values()) {
                    table.getIndexes().add(exampleIndex);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        if (foundObject instanceof UniqueConstraint && ((UniqueConstraint)foundObject).getBackingIndex() == null && !(snapshot.getDatabase() instanceof DB2Database) && !(snapshot.getDatabase() instanceof DerbyDatabase)) {
            Index exampleIndex = new Index().setTable(((UniqueConstraint)foundObject).getTable());
            exampleIndex.getColumns().addAll(((UniqueConstraint)foundObject).getColumns());
            ((UniqueConstraint)foundObject).setBackingIndex(exampleIndex);
        }
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Table exampleTable = ((Index)example).getTable();
        String tableName = null;
        Schema schema = null;
        if (exampleTable != null) {
            tableName = exampleTable.getName();
            schema = exampleTable.getSchema();
        }
        if (schema == null) {
            schema = new Schema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
        }
        for (int i = 0; i < ((Index)example).getColumns().size(); ++i) {
            ((Index)example).getColumns().set(i, ((Index)example).getColumns().get(i));
        }
        String exampleName = example.getName();
        if (exampleName != null) {
            exampleName = database.correctObjectName(exampleName, Index.class);
        }
        HashMap<String, Index> foundIndexes = new HashMap<String, Index>();
        JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = null;
        List<CachedRow> rs = null;
        try {
            databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
            rs = databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), tableName, exampleName);
            for (CachedRow row : rs) {
                String definition;
                String rawIndexName = row.getString("INDEX_NAME");
                String indexName = this.cleanNameFromDatabase(rawIndexName, database);
                String correctedIndexName = database.correctObjectName(indexName, Index.class);
                if (indexName == null || exampleName != null && !exampleName.equals(correctedIndexName) || database instanceof InformixDatabase && indexName.startsWith(" ")) continue;
                short type = row.getShort("TYPE");
                Boolean nonUnique = row.getBoolean("NON_UNIQUE");
                if (nonUnique == null) {
                    nonUnique = true;
                }
                String columnName = this.cleanNameFromDatabase(row.getString("COLUMN_NAME"), database);
                short position = row.getShort("ORDINAL_POSITION");
                if (database instanceof InformixDatabase && type != 0 && position == 0) {
                    position = (short)(position + 1);
                    System.out.println(this.getClass().getName() + ": corrected position to " + position);
                }
                if ((definition = StringUtils.trimToNull(row.getString("FILTER_CONDITION"))) != null && !(database instanceof OracleDatabase)) {
                    definition = definition.replaceAll("\"", "");
                }
                if (type == 0 || columnName == null && definition == null) continue;
                Index returnIndex = (Index)foundIndexes.get(correctedIndexName);
                if (returnIndex == null) {
                    returnIndex = new Index();
                    returnIndex.setTable((Table)new Table().setName(row.getString("TABLE_NAME")).setSchema(schema));
                    returnIndex.setName(indexName);
                    returnIndex.setUnique(nonUnique == false);
                    if (type == 1) {
                        returnIndex.setClustered(true);
                    } else if (database instanceof MSSQLDatabase) {
                        returnIndex.setClustered(false);
                    }
                    foundIndexes.put(correctedIndexName, returnIndex);
                }
                for (int i = returnIndex.getColumns().size(); i < position; ++i) {
                    returnIndex.getColumns().add(null);
                }
                if (definition == null) {
                    String ascOrDesc = row.getString("ASC_OR_DESC");
                    Boolean descending = "D".equals(ascOrDesc) ? Boolean.TRUE : ("A".equals(ascOrDesc) ? Boolean.FALSE : null);
                    returnIndex.getColumns().set(position - 1, new Column(columnName).setDescending(descending).setRelation(returnIndex.getTable()));
                    continue;
                }
                returnIndex.getColumns().set(position - 1, new Column().setRelation(returnIndex.getTable()).setName(definition, true));
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        if (exampleName != null) {
            Index index = null;
            index = database instanceof InformixDatabase ? (Index)foundIndexes.get("_generated_index_" + exampleName.substring(1)) : (Index)foundIndexes.get(exampleName);
            return index;
        }
        for (Index index : foundIndexes.values()) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(index.getTable(), exampleTable, database) || !(database.isCaseSensitive() ? index.getColumnNames().equals(((Index)example).getColumnNames()) : index.getColumnNames().equalsIgnoreCase(((Index)example).getColumnNames()))) continue;
            return index;
        }
        return null;
    }
}

