/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.supplier.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.core.supplier.AddColumnConfigSupplier;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.supplier.change.ChangeSupplier;
import liquibase.util.CollectionUtil;

public abstract class AbstractChangeSupplier<T extends Change>
implements ChangeSupplier<T> {
    private final String changeName;

    protected AbstractChangeSupplier(Class<? extends Change> changeClass) {
        try {
            this.changeName = changeClass.newInstance().getSerializedObjectName();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public String getChangeName() {
        return this.changeName;
    }

    @Override
    public Change[] revertDatabase(T change) throws Exception {
        return null;
    }

    @Override
    public Collection<Change> getAllParameterPermutations(Database database) throws Exception {
        ChangeMetaData changeMetaData = ChangeFactory.getInstance().getChangeMetaData(this.getChangeName());
        Set<Set<String>> parameterSets = CollectionUtil.powerSet(changeMetaData.getParameters().keySet());
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Set<String> params : parameterSets) {
            HashMap parameterValues = new HashMap();
            for (String string : params) {
                ChangeParameterMetaData changeParam = changeMetaData.getParameters().get(string);
                parameterValues.put(string, new ArrayList());
                ((List)parameterValues.get(string)).addAll(this.getTestValues(changeParam, database));
            }
            for (Map map : CollectionUtil.permutations(parameterValues)) {
                Change change = ChangeFactory.getInstance().create(this.getChangeName());
                for (Map.Entry entry : map.entrySet()) {
                    ChangeParameterMetaData changeParam = changeMetaData.getParameters().get(entry.getKey());
                    changeParam.setValue(change, entry.getValue());
                }
                changes.add(change);
            }
        }
        return changes;
    }

    protected List getTestValues(ChangeParameterMetaData changeParam, Database database) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        if (changeParam.getDataType().equals("list of addColumnConfig")) {
            for (AddColumnConfig config : this.getAddColumnConfigSupplier().getStandardPermutations(database)) {
                values.add(new ArrayList<AddColumnConfig>(Arrays.asList(config)));
            }
        } else {
            Object exampleValue = changeParam.getExampleValue(database);
            values.add(exampleValue);
        }
        return values;
    }

    protected AddColumnConfigSupplier getAddColumnConfigSupplier() {
        return new AddColumnConfigSupplier();
    }

    @Override
    public boolean isValid(Change change, Database database) {
        return !change.validate(database).hasErrors();
    }
}

