/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.CreateProcedureStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;

public class CreateProcedureGenerator
extends AbstractSqlGenerator<CreateProcedureStatement> {
    @Override
    public ValidationErrors validate(CreateProcedureStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("procedureText", statement.getProcedureText());
        if (statement.getReplaceIfExists() != null) {
            if (database instanceof MSSQLDatabase) {
                if (statement.getReplaceIfExists().booleanValue() && statement.getProcedureName() == null) {
                    validationErrors.addError("procedureName is required if replaceIfExists = true");
                }
            } else {
                validationErrors.checkDisallowedField("replaceIfExists", statement.getReplaceIfExists(), null, new Class[0]);
            }
        }
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(CreateProcedureStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        String procedureText = statement.getProcedureText();
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            sql.add(new UnparsedSql("if object_id('dbo." + statement.getProcedureName() + "', 'p') is null exec ('create procedure " + database.escapeObjectName(statement.getProcedureName(), StoredProcedure.class) + " as select 1 a')", new DatabaseObject[0]));
            procedureText = procedureText.replaceFirst("(?i)create\\s+procedure", "ALTER PROCEDURE");
        }
        sql.add(new UnparsedSql(procedureText, statement.getEndDelimiter(), new DatabaseObject[0]));
        return sql.toArray(new Sql[sql.size()]);
    }
}

