/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.tomcat.LogoutHandler;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public abstract class AbstractLogoutHandler
implements LogoutHandler {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        Assertion assertion;
        this.log.debug((Object)"Processing logout request from CAS server.");
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (assertion = (Assertion)httpSession.getAttribute("_const_cas_assertion_")) != null) {
            httpSession.removeAttribute("_const_cas_assertion_");
            this.log.info((Object)("Successfully logged out " + assertion.getPrincipal()));
        } else {
            this.log.info((Object)"Session already ended.");
        }
        String redirectUrl = this.constructRedirectUrl(request);
        if (redirectUrl != null) {
            this.log.debug((Object)("Redirecting to " + redirectUrl));
            CommonUtils.sendRedirect((HttpServletResponse)response, (String)redirectUrl);
        }
    }

    protected String constructRedirectUrl(HttpServletRequest request) {
        return this.redirectUrl;
    }
}

