/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.supplier.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.sdk.supplier.database.ConnectionConfigurationFactory;
import liquibase.sdk.supplier.database.ConnectionSupplier;

public class DatabaseSupplier {
    private HashSet<Database> allDatabases;

    public Set<Database> getAllDatabases() {
        if (this.allDatabases == null) {
            this.allDatabases = new HashSet<Database>(DatabaseFactory.getInstance().getImplementedDatabases());
            block2: for (Database database : this.allDatabases) {
                ConnectionConfigurationFactory configurationFactory = ConnectionConfigurationFactory.getInstance();
                for (ConnectionSupplier connectionSupplier : configurationFactory.getConfigurations(database)) {
                    try {
                        Connection connection = connectionSupplier.openConnection();
                        database.setConnection(new JdbcConnection(connection));
                        continue block2;
                    }
                    catch (SQLException e) {
                        System.out.println("Cannot connect to " + connectionSupplier.getJdbcUrl());
                        database.setConnection(new OfflineConnection("offline:" + database.getShortName()));
                    }
                }
            }
        }
        return this.allDatabases;
    }
}

