/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SystemElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class SearchSystemPropositionJSTreeV1Servlet
extends HttpServlet {
    private final ServicesClient servicesClient;

    @Inject
    public SearchSystemPropositionJSTreeV1Servlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private JsonTreeData createData(SystemElement element) {
        JsonTreeData d = new JsonTreeData();
        d.setState("closed");
        d.setId(element.getKey());
        d.setData(this.getDisplayName(element));
        d.setText(this.getDisplayName(element));
        d.setKeyVal("id", element.getKey());
        String properties = StringUtils.join((Iterable)element.getProperties(), (String)",");
        d.setKeyVal("data-properties", properties);
        d.setKeyVal("data-key", element.getKey());
        d.setKeyVal("data-space", "system");
        d.setKeyVal("data-type", element.getSystemType().toString());
        d.setKeyVal("data-proposition", element.getKey());
        d.setChildren(false);
        return d;
    }

    private String getDisplayName(SystemElement p) {
        String displayName = "";
        displayName = p.getDisplayName() != null && !p.getDisplayName().equals("") ? p.getDisplayName() + " (" + p.getKey() + ")" : p.getKey();
        return displayName;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String searchKey = req.getParameter("str");
        ArrayList l = new ArrayList();
        if (searchKey == null) {
            throw new ServletException("Search key is null");
        }
        try {
            List processedSearchResult = null;
            List searchResult = null;
            searchResult = this.servicesClient.getSystemElementSearchResults(searchKey);
            processedSearchResult = this.convertResultsForJstreeRequirement(searchResult);
            ObjectMapper mapper = new ObjectMapper();
            resp.setContentType("application/json");
            PrintWriter out = resp.getWriter();
            mapper.writeValue((Writer)out, (Object)processedSearchResult);
        }
        catch (ClientException e) {
            throw new ServletException("Error getting search results", (Throwable)e);
        }
    }

    private List<String> convertResultsForJstreeRequirement(List<String> searchResult) {
        ArrayList<String> newResultSet = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9]");
        newResultSet.add("#root");
        for (String currentSearchResult : searchResult) {
            newResultSet.add("#" + pattern.matcher(currentSearchResult).replaceAll("\\\\$0"));
        }
        return newResultSet;
    }
}

