/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserInfoFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserInfoFilter.class);
    private ServicesClient servicesClient;

    @Inject
    public UserInfoFilter(ServicesClient inServicesClient) {
        this.servicesClient = inServicesClient;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        User user;
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        String remoteUser = servletRequest.getRemoteUser();
        boolean userIsActivated = false;
        if (!StringUtils.isEmpty((CharSequence)remoteUser) && (user = (User)inRequest.getAttribute("user")) != null && user.isActive()) {
            userIsActivated = true;
        }
        inRequest.setAttribute("userIsActivated", (Object)userIsActivated);
        inFilterChain.doFilter(inRequest, inResponse);
    }

    public void destroy() {
    }
}

