/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.cohort;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Cohort;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.CohortDestination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Node;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.NodeVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.cohort.EditCohortServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditCohortServlet
extends HttpServlet {
    private final ServicesClient servicesClient;

    @Inject
    public EditCohortServlet(ServicesClient servicesClient) {
        this.servicesClient = servicesClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cohortName = req.getParameter("key");
        if (cohortName != null) {
            try {
                CohortDestination destination = (CohortDestination)this.servicesClient.getDestination(cohortName);
                req.setAttribute("destId", (Object)destination.getId());
                req.setAttribute("name", (Object)destination.getName());
                req.setAttribute("description", (Object)destination.getDescription());
                Cohort cohort = destination.getCohort();
                Node node = cohort.getNode();
                EditCohortNodeVisitor v = new EditCohortNodeVisitor(this, null);
                node.accept((NodeVisitor)v);
                req.setAttribute("phenotypes", (Object)v.getPhenotypes());
            }
            catch (ClientException ex) {
                throw new ServletException("Error setting up cohort editor", (Throwable)ex);
            }
        }
        req.getRequestDispatcher("/protected/cohort_editor.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    static /* synthetic */ ServicesClient access$100(EditCohortServlet x0) {
        return x0.servicesClient;
    }
}

