/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessagesFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessagesFilter.class);
    private ServletContext servletContext;

    public void init(FilterConfig fc) throws ServletException {
        this.servletContext = fc.getServletContext();
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        Locale locale = inRequest.getLocale();
        String resourceBundleName = this.servletContext.getInitParameter("javax.servlet.jsp.jstl.fmt.localizationContext");
        LOGGER.debug("Sending response text using locale {}", (Object)locale);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale);
        inRequest.setAttribute("messages", (Object)resourceBundle);
        inFilterChain.doFilter(inRequest, inResponse);
    }

    public void destroy() {
    }
}

