/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgotPasswordServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ForgotPasswordServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public ForgotPasswordServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String email = request.getParameter("email");
        try {
            this.servicesClient.resetPassword(email);
            response.setStatus(200);
            response.getWriter().write(200);
        }
        catch (ClientException ex) {
            LOGGER.error("Error resetting password for user {}", (Object)email, (Object)ex);
            if (ClientResponse.Status.NOT_FOUND.equals((Object)ex.getResponseStatus())) {
                response.setStatus(404);
            }
            response.setStatus(500);
            response.getWriter().write(ex.getMessage());
        }
    }
}

