/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class LogoutServlet
extends HttpServlet {
    private final WebappProperties webappProperties;

    @Inject
    public LogoutServlet(WebappProperties inProperties) {
        this.webappProperties = inProperties;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        StringBuilder buf = new StringBuilder();
        String casLogoutUrl = this.webappProperties.getCasLogoutUrl();
        buf.append(casLogoutUrl);
        String awaitingActivation = req.getParameter("awaitingActivation");
        boolean aaEmpty = StringUtils.isEmpty((CharSequence)awaitingActivation);
        if (!aaEmpty && BooleanUtils.toBooleanObject((String)awaitingActivation) == null) {
            resp.sendError(400);
            return;
        }
        String notRegistered = req.getParameter("notRegistered");
        boolean nrEmpty = StringUtils.isEmpty((CharSequence)notRegistered);
        if (!nrEmpty && BooleanUtils.toBooleanObject((String)notRegistered) == null) {
            resp.sendError(400);
            return;
        }
        if (!aaEmpty || !nrEmpty) {
            buf.append('?');
        }
        if (!aaEmpty) {
            buf.append("awaitingActivation=").append(awaitingActivation);
        }
        if (!aaEmpty && !nrEmpty) {
            buf.append('&');
        }
        if (!nrEmpty) {
            buf.append("notRegistered=").append(notRegistered);
        }
        this.log("URL IS " + buf.toString());
        resp.sendRedirect(buf.toString());
    }
}

