/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorHomeServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorHomeServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public EditorHomeServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    private JsonTreeData createData(String key, String data) {
        JsonTreeData d = new JsonTreeData();
        d.setData(data);
        d.setKeyVal("key", key);
        return d;
    }

    private String getDisplayName(DataElement e) {
        String displayName = "";
        displayName = e.getDisplayName() != null && !e.getDisplayName().equals("") ? e.getDisplayName() + "(" + e.getKey() + ")" : e.getKey();
        return displayName;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List props;
        ArrayList<JsonTreeData> l = new ArrayList<JsonTreeData>();
        try {
            props = this.servicesClient.getUserElements(true);
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting user-defined data elements", (Throwable)ex);
        }
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        for (DataElement proposition : props) {
            JsonTreeData d = this.createData(proposition.getKey(), this.getDisplayName(proposition));
            d.setKeyVal("description", proposition.getDescription());
            d.setKeyVal("displayName", proposition.getDisplayName());
            if (proposition.getType() == DataElement.Type.CATEGORIZATION) {
                d.setKeyVal("type", "Categorical");
            } else if (proposition.getType() == DataElement.Type.SEQUENCE) {
                d.setKeyVal("type", "Sequence");
            } else if (proposition.getType() == DataElement.Type.FREQUENCY) {
                d.setKeyVal("type", "Frequency");
            } else if (proposition.getType() == DataElement.Type.VALUE_THRESHOLD) {
                d.setKeyVal("type", "Value Threshold");
            }
            if (proposition.getCreated() != null) {
                LOGGER.debug("created date: " + df.format(proposition.getCreated()));
                d.setKeyVal("created", df.format(proposition.getCreated()));
            }
            if (proposition.getLastModified() != null) {
                d.setKeyVal("lastModified", df.format(proposition.getLastModified()));
            }
            l.add(d);
            LOGGER.debug("Added user prop: " + d.getData());
        }
        req.setAttribute("props", l);
        req.getRequestDispatcher("/protected/editor_home.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

