/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Category;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElementField;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.PropositionListSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUserDefinedPropositionChildrenServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListUserDefinedPropositionChildrenServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;
    private final PropositionListSupport propListSupport;

    @Inject
    public ListUserDefinedPropositionChildrenServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.propListSupport = new PropositionListSupport();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private JsonTreeData createData(String data, String key) {
        JsonTreeData d = new JsonTreeData();
        d.setData(data);
        d.setKeyVal("key", key);
        d.setKeyVal("data-key", key);
        return d;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void getAllData(JsonTreeData d) throws ClientException {
        DataElement dataElement = this.servicesClient.getUserElement((String)d.getAttr().get("data-key"), false);
        if (dataElement.getType() == DataElement.Type.CATEGORIZATION) {
            JsonTreeData newData;
            Category ce = (Category)dataElement;
            for (DataElementField de : ce.getChildren()) {
                if (!de.isInSystem()) continue;
                newData = this.createData(this.propListSupport.getDisplayName(de), de.getDataElementKey());
                newData.setType("system");
                LOGGER.debug("add sysTarget {}", (Object)de.getDataElementKey());
                d.setChildren(true);
            }
            for (DataElementField userDataElement : ce.getChildren()) {
                if (userDataElement.isInSystem()) continue;
                newData = this.createData(userDataElement.getDataElementDescription(), userDataElement.getDataElementKey());
                this.getAllData(newData);
                newData.setType("user");
                LOGGER.debug("add user defined {}", (Object)userDataElement.getDataElementKey());
                d.setChildren(true);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<JsonTreeData> l = new ArrayList<JsonTreeData>();
        String propKey = req.getParameter("propKey");
        try {
            DataElement dataElement = this.servicesClient.getUserElement(propKey, false);
            JsonTreeData newData = this.createData(this.propListSupport.getDisplayName(dataElement), propKey);
            this.getAllData(newData);
            l.add(newData);
            resp.setContentType("application/json");
            PrintWriter out = resp.getWriter();
            MAPPER.writeValue((Writer)out, l);
        }
        catch (ClientException ex) {
            throw new ServletException("error getting user defined data element " + propKey, (Throwable)ex);
        }
    }
}

