/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Job;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.JobListRow;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;

public class JobPollServlet
extends HttpServlet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;

    @Inject
    public JobPollServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        String jobIdStr = req.getParameter("jobId");
        Long jobId = null;
        if (jobIdStr != null) {
            try {
                jobId = Long.valueOf(jobIdStr);
            }
            catch (NumberFormatException nfe) {
                throw new ServletException("jobId parameter must be a long, was " + jobIdStr);
            }
        }
        Job job = null;
        Destination destination = null;
        String destinationId = null;
        try {
            if (jobId != null) {
                job = this.servicesClient.getJob(jobId);
                destinationId = job.getDestinationId();
                destination = this.servicesClient.getDestination(destinationId);
            } else {
                List jobs = this.servicesClient.getJobsDesc();
                if (!jobs.isEmpty()) {
                    job = (Job)jobs.get(0);
                    destinationId = job.getDestinationId();
                    destination = this.servicesClient.getDestination(destinationId);
                }
            }
        }
        catch (ClientException ex) {
            throw new ServletException("Error polling job list", (Throwable)ex);
        }
        JobListRow jobListRow = null;
        if (job != null && destination != null) {
            job.setGetStatisticsSupported(destination.isGetStatisticsSupported());
            jobListRow = job.toJobListRow();
        }
        String value = MAPPER.writeValueAsString(jobListRow);
        resp.setContentLength(value.length());
        PrintWriter out = resp.getWriter();
        out.println(value);
    }
}

