/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.taglib;

import edu.emory.cci.aiw.cvrg.eureka.common.props.SupportUri;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.beans.IntrospectionException;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.jboss.logging.Logger;

public class SupportUriTag
extends TagSupport {
    private static final WebappProperties properties = new WebappProperties();
    private static final Logger LOGGER = Logger.getLogger(SupportUriTag.class);
    private String hyperlinkClass = "";

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(this.supportUri());
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Error writing support URI", (Throwable)ex);
            throw new JspException("Error writing support URI", (Throwable)ex);
        }
        return 0;
    }

    public String getHyperlinkClass() {
        return this.hyperlinkClass;
    }

    public void setHyperlinkClass(String hyperlinkClass) {
        this.hyperlinkClass = hyperlinkClass == null ? "" : hyperlinkClass;
    }

    private String supportUri() {
        SupportUri supportUri = properties.getSupportUri();
        if (supportUri == null) {
            return null;
        }
        if (supportUri.isHyperlinkable()) {
            return "<a href=\"" + supportUri + "\" class=\"" + this.hyperlinkClass + "\">" + supportUri.getName() + "</a>";
        }
        return supportUri.toString();
    }

    public static boolean isSupportUriDefined() {
        return properties.getSupportUri() != null;
    }
}

