/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;

public class DateRangePhenotypeServlet
extends HttpServlet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;

    @Inject
    public DateRangePhenotypeServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Destination destination;
        resp.setContentType("application/json");
        String destinationId = req.getParameter("destinationId");
        if (destinationId == null) {
            throw new ServletException("Missing query parameter 'destinationId'");
        }
        try {
            destination = this.servicesClient.getDestination(destinationId);
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting destination '" + destinationId + "'");
        }
        String json = MAPPER.writeValueAsString((Object)destination.getPhenotypeFields());
        resp.setContentLength(json.length());
        PrintWriter out = resp.getWriter();
        out.println(json);
    }
}

