/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.webapp.config;

import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.common.config.AbstractServletModule;
import edu.emory.cci.aiw.cvrg.eureka.common.props.AbstractProperties;
import edu.emory.cci.aiw.cvrg.eureka.servlet.AdminManagerServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.ChooseAccountTypeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.DateRangePhenotypeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.ForgotPasswordServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobListServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobPatientCountsServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobPollServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobStatsServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobSubmitServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.LoginServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.LogoutServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.ProxyServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.RegisterUserServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.UserAcctManagerServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.VerifyUserServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.cohort.CohortHomeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.cohort.DeleteCohortServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.cohort.EditCohortServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.cohort.SaveCohortServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.HaveUserRecordFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.MessagesFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.PasswordExpiredFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.UserInfoFilter;
import edu.emory.cci.aiw.cvrg.eureka.servlet.oauth.GitHubRegistrationOAuthCallbackServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.oauth.GlobusRegistrationOAuthCallbackServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.oauth.GoogleRegistrationOAuthCallbackServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.oauth.TwitterRegistrationOAuthCallbackServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.DeletePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditPropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditorHomeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.ListUserDefinedPropositionChildrenServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SavePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SearchSystemPropositionJSTreeV1Servlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SearchSystemPropositionJSTreeV3Servlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SystemPropositionListServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.UserPropositionListServlet;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletModule
extends AbstractServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletModule.class);
    private static final String CONTAINER_PATH = "/site/*";
    private static final String CONTAINER_PROTECTED_PATH = "/protected/*";
    private static final String PASSWORD_EXPIRED_REDIRECT_URL = "/protected/password_expiration.jsp";
    private static final String PASSWORD_SAVE_PATH = "/protected/user_acct";
    private static final String LOGOUT_PATH = "/logout";
    private final WebappProperties properties;

    public ServletModule(WebappProperties inProperties) {
        super((AbstractProperties)inProperties, CONTAINER_PATH, CONTAINER_PROTECTED_PATH, LOGOUT_PATH);
        this.properties = inProperties;
    }

    private void setupMessageFilter() {
        this.bind(MessagesFilter.class).in(Singleton.class);
        this.filterRegex("^/(?!assets).*", new String[0]).through(MessagesFilter.class);
    }

    private void setupHaveUserRecordFilter() {
        this.bind(HaveUserRecordFilter.class).in(Singleton.class);
        this.filterRegex("^/(?!assets).*", new String[0]).through(HaveUserRecordFilter.class);
    }

    private void setupUserInfoFilter() {
        this.bind(UserInfoFilter.class).in(Singleton.class);
        this.filterRegex("^/(?!assets).*", new String[0]).through(UserInfoFilter.class);
    }

    private void setupPasswordExpiredFilter() {
        this.bind(PasswordExpiredFilter.class).in(Singleton.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect-url", PASSWORD_EXPIRED_REDIRECT_URL);
        params.put("save-url", PASSWORD_SAVE_PATH);
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        this.filter(CONTAINER_PROTECTED_PATH, new String[0]).through(PasswordExpiredFilter.class, params);
    }

    protected void setupFilters() {
        this.setupMessageFilter();
        this.setupHaveUserRecordFilter();
        this.setupUserInfoFilter();
        this.setupPasswordExpiredFilter();
    }

    protected void setupServlets() {
        this.bind(RegisterUserServlet.class).in(Singleton.class);
        this.serve("/register", new String[0]).with(RegisterUserServlet.class);
        this.bind(ProxyServlet.class).in(Singleton.class);
        this.serve("/proxy-resource/*", new String[0]).with(ProxyServlet.class);
        this.bind(ForgotPasswordServlet.class).in(Singleton.class);
        this.serve("/forgot_password", new String[0]).with(ForgotPasswordServlet.class);
        this.bind(LogoutServlet.class).in(Singleton.class);
        this.serve(LOGOUT_PATH, new String[0]).with(LogoutServlet.class);
        this.bind(VerifyUserServlet.class).in(Singleton.class);
        this.serve("/verify", new String[0]).with(VerifyUserServlet.class);
        this.bind(JobSubmitServlet.class).in(Singleton.class);
        HashMap<String, String> uploadParams = new HashMap<String, String>();
        uploadParams.put("dest_dir", this.properties.getUploadDir());
        this.serve("/protected/upload", new String[0]).with(JobSubmitServlet.class, uploadParams);
        this.bind(LoginServlet.class).in(Singleton.class);
        this.serve("/protected/login", new String[0]).with(LoginServlet.class);
        this.bind(JobPollServlet.class).in(Singleton.class);
        this.serve("/protected/jobpoll", new String[0]).with(JobPollServlet.class);
        this.bind(JobListServlet.class).in(Singleton.class);
        this.serve("/protected/jobs", new String[0]).with(JobListServlet.class);
        this.bind(JobStatsServlet.class).in(Singleton.class);
        this.serve("/protected/jobstats", new String[0]).with(JobStatsServlet.class);
        this.bind(JobPatientCountsServlet.class).in(Singleton.class);
        this.serve("/protected/jobpatcounts", new String[0]).with(JobPatientCountsServlet.class);
        this.bind(AdminManagerServlet.class).in(Singleton.class);
        this.serve("/protected/admin", new String[0]).with(AdminManagerServlet.class);
        this.bind(UserAcctManagerServlet.class).in(Singleton.class);
        this.serve(PASSWORD_SAVE_PATH, new String[0]).with(UserAcctManagerServlet.class);
        this.bind(EditorHomeServlet.class).in(Singleton.class);
        this.serve("/protected/editorhome", new String[0]).with(EditorHomeServlet.class);
        this.bind(SystemPropositionListServlet.class).in(Singleton.class);
        this.serve("/protected/systemlist", new String[0]).with(SystemPropositionListServlet.class);
        this.bind(SavePropositionServlet.class).in(Singleton.class);
        this.serve("/protected/saveprop", new String[0]).with(SavePropositionServlet.class);
        this.bind(DeletePropositionServlet.class).in(Singleton.class);
        this.serve("/protected/deleteprop", new String[0]).with(DeletePropositionServlet.class);
        this.bind(UserPropositionListServlet.class).in(Singleton.class);
        this.serve("/protected/userproplist", new String[0]).with(UserPropositionListServlet.class);
        this.bind(ListUserDefinedPropositionChildrenServlet.class).in(Singleton.class);
        this.serve("/protected/userpropchildren", new String[0]).with(ListUserDefinedPropositionChildrenServlet.class);
        this.bind(EditPropositionServlet.class).in(Singleton.class);
        this.serve("/protected/editprop", new String[0]).with(EditPropositionServlet.class);
        this.bind(DateRangePhenotypeServlet.class).in(Singleton.class);
        this.serve("/protected/destinationphenotypes", new String[0]).with(DateRangePhenotypeServlet.class);
        this.bind(SearchSystemPropositionJSTreeV3Servlet.class).in(Singleton.class);
        this.serve("/protected/jstree3_searchsystemlist", new String[0]).with(SearchSystemPropositionJSTreeV3Servlet.class);
        this.bind(SearchSystemPropositionJSTreeV1Servlet.class).in(Singleton.class);
        this.serve("/protected/searchsystemlist", new String[0]).with(SearchSystemPropositionJSTreeV1Servlet.class);
        this.bind(CohortHomeServlet.class).in(Singleton.class);
        this.serve("/protected/cohorthome", new String[0]).with(CohortHomeServlet.class);
        this.bind(EditCohortServlet.class).in(Singleton.class);
        this.serve("/protected/editcohort", new String[0]).with(EditCohortServlet.class);
        this.bind(SaveCohortServlet.class).in(Singleton.class);
        this.serve("/protected/savecohort", new String[0]).with(SaveCohortServlet.class);
        this.bind(DeleteCohortServlet.class).in(Singleton.class);
        this.serve("/protected/deletecohort", new String[0]).with(DeleteCohortServlet.class);
        this.bind(ChooseAccountTypeServlet.class).in(Singleton.class);
        this.serve("/chooseaccounttype", new String[0]).with(ChooseAccountTypeServlet.class);
        this.bind(GitHubRegistrationOAuthCallbackServlet.class).in(Singleton.class);
        this.serve("/registrationoauthgithubcallback", new String[0]).with(GitHubRegistrationOAuthCallbackServlet.class);
        this.bind(GoogleRegistrationOAuthCallbackServlet.class).in(Singleton.class);
        this.serve("/registrationoauthgooglecallback", new String[0]).with(GoogleRegistrationOAuthCallbackServlet.class);
        this.bind(TwitterRegistrationOAuthCallbackServlet.class).in(Singleton.class);
        this.serve("/registrationoauthtwittercallback", new String[0]).with(TwitterRegistrationOAuthCallbackServlet.class);
        this.bind(GlobusRegistrationOAuthCallbackServlet.class).in(Singleton.class);
        this.serve("/registrationoauthglobuscallback", new String[0]).with(GlobusRegistrationOAuthCallbackServlet.class);
    }
}

