/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Destination;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Job;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.DateRangeSide;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JobListServlet
extends HttpServlet {
    private final ServicesClient servicesClient;

    @Inject
    public JobListServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            List sourceConfigs = this.servicesClient.getSourceConfigs();
            req.setAttribute("sources", (Object)sourceConfigs);
            List destinations = this.servicesClient.getDestinations();
            req.setAttribute("destinations", (Object)destinations);
            req.setAttribute("dateRangeSides", (Object)DateRangeSide.values());
            String jobIdStr = req.getParameter("jobId");
            Job job = null;
            if (jobIdStr != null) {
                Long jobId;
                try {
                    jobId = Long.valueOf(jobIdStr);
                }
                catch (NumberFormatException ex) {
                    throw new ServletException("Query parameter jobId must be a long, was " + jobIdStr);
                }
                job = this.servicesClient.getJob(jobId);
            } else {
                List jobs = this.servicesClient.getLatestJob();
                if (!jobs.isEmpty()) {
                    job = (Job)jobs.get(0);
                }
            }
            if (job != null) {
                req.setAttribute("jobId", (Object)job.getId());
                String sourceConfigName = job.getSourceConfigId();
                req.setAttribute("sourceConfig", (Object)sourceConfigName);
                String destName = job.getDestinationId();
                Destination destination = null;
                for (Destination candidateDest : destinations) {
                    if (!candidateDest.getName().equals(destName)) continue;
                    destination = candidateDest;
                    break;
                }
                if (destination != null) {
                    req.setAttribute("destination", destination);
                    job.setGetStatisticsSupported(destination.isGetStatisticsSupported());
                    req.setAttribute("jobStatus", (Object)job.toJobListRow());
                } else {
                    throw new ServletException("Can't find destination " + destName);
                }
            }
            req.getRequestDispatcher("/protected/job_submission.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting job list", (Throwable)ex);
        }
    }
}

