/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.JobSpec;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.JobSubmitServlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class JobSubmitServlet
extends HttpServlet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private File tmpDir;
    private final ServicesClient servicesClient;

    @Inject
    public JobSubmitServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tmpDir = FileUtils.getTempDirectory();
        if (!this.tmpDir.isDirectory()) {
            throw new ServletException(this.tmpDir.getAbsolutePath() + " is not a directory");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            throw new ServletException("Spreadsheet upload attempt: no user associated with the request");
        }
        SubmitJobResponse jobResponse = new SubmitJobResponse(null);
        try {
            Long jobId = this.submitJob(request, principal);
            jobResponse.setJobId(jobId);
        }
        catch (ParseException ex) {
            jobResponse.setMessage("The date range you specified is invalid.");
            jobResponse.setStatusCode(400);
            jobResponse.setErrorThrown("Bad request");
            response.setStatus(400);
        }
        catch (ClientException | IOException | FileUploadException ex) {
            String msg = "Upload failed due to an internal error";
            jobResponse.setMessage(msg);
            jobResponse.setStatusCode(500);
            jobResponse.setErrorThrown("Internal server error");
            this.log("Upload failed for user " + principal.getName(), ex);
            response.setStatus(500);
        }
        String value = MAPPER.writeValueAsString((Object)jobResponse);
        response.setContentLength(value.length());
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        out.println(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long submitJob(HttpServletRequest request, Principal principal) throws FileUploadException, IOException, ClientException, ParseException {
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setSizeThreshold(0x500000);
        fileItemFactory.setRepository(this.tmpDir);
        ServletFileUpload uploadHandler = new ServletFileUpload((FileItemFactory)fileItemFactory);
        List items = uploadHandler.parseRequest(request);
        Properties fields = new Properties();
        for (FileItem item : items) {
            if (!item.isFormField()) continue;
            fields.setProperty(item.getFieldName(), item.getString());
        }
        JobSpec jobSpec = (JobSpec)MAPPER.readValue(fields.getProperty("jobSpec"), JobSpec.class);
        for (FileItem item : items) {
            if (item.isFormField()) continue;
            this.log("Spreadsheet upload for user " + principal.getName() + ": Field Name = " + item.getFieldName() + ", File Name = " + item.getName() + ", Content type = " + item.getContentType() + ", File Size = " + item.getSize());
            if (item.getSize() > 0L) {
                InputStream is = item.getInputStream();
                try {
                    this.servicesClient.upload(FilenameUtils.getName((String)item.getName()), jobSpec.getSourceConfigId(), item.getFieldName(), is);
                    this.log("File '" + item.getName() + "' uploaded successfully");
                    continue;
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            this.log("File '" + item.getName() + "' ignored because it was zero length");
        }
        URI uri = this.servicesClient.submitJob(jobSpec);
        String uriStr = uri.toString();
        Long jobId = Long.valueOf(uriStr.substring(uriStr.lastIndexOf("/") + 1));
        this.log("Job " + jobId + " submitted for user " + principal.getName());
        return jobId;
    }

    static {
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("MM/dd/yyyy"));
    }
}

