/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.MessagesFilter;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HaveUserRecordFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessagesFilter.class);
    private final ServicesClient servicesClient;
    private final WebappProperties properties;

    @Inject
    public HaveUserRecordFilter(ServicesClient inServicesClient, WebappProperties inProperties) {
        this.servicesClient = inServicesClient;
        this.properties = inProperties;
    }

    public void init(FilterConfig inFilterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        HttpServletResponse servletResponse = (HttpServletResponse)inResponse;
        String remoteUser = servletRequest.getRemoteUser();
        if (!StringUtils.isEmpty((CharSequence)remoteUser)) {
            try {
                User user = this.servicesClient.getMe();
                if (!user.isActive()) {
                    HttpSession session = servletRequest.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    this.sendForbiddenError(servletResponse, servletRequest, true);
                }
                inRequest.setAttribute("user", (Object)user);
                inFilterChain.doFilter(inRequest, inResponse);
            }
            catch (ClientException ex) {
                if (ClientResponse.Status.FORBIDDEN.equals((Object)ex.getResponseStatus())) {
                    HttpSession session = servletRequest.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    this.sendForbiddenError(servletResponse, servletRequest, false);
                }
                if (ClientResponse.Status.UNAUTHORIZED.equals((Object)ex.getResponseStatus())) {
                    HttpSession session = servletRequest.getSession(false);
                    if (session != null) {
                        session.invalidate();
                    }
                    servletResponse.sendRedirect(servletRequest.getContextPath() + "/logout?goHome=true");
                }
                throw new ServletException("Error getting user " + servletRequest.getRemoteUser(), (Throwable)ex);
            }
        } else {
            inFilterChain.doFilter(inRequest, inResponse);
        }
    }

    private void sendForbiddenError(HttpServletResponse servletResponse, HttpServletRequest servletRequest, boolean created) throws IOException {
        if (this.properties.isRegistrationEnabled()) {
            servletResponse.setStatus(403);
            if (created) {
                servletResponse.sendRedirect(servletRequest.getContextPath() + "/logout?awaitingActivation=true");
            } else {
                servletResponse.sendRedirect(servletRequest.getContextPath() + "/logout?notRegistered=true");
            }
        } else {
            servletResponse.sendError(403);
        }
    }

    public void destroy() {
    }
}

