/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.DeletePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.webapp.authentication.WebappAuthenticationSupport;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletePropositionServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletePropositionServlet.class);
    private final ServicesClient servicesClient;
    private final WebappAuthenticationSupport authenticationSupport;

    @Inject
    public DeletePropositionServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.authenticationSupport = new WebappAuthenticationSupport(this.servicesClient);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("DeletePropositionServlet");
        Long propId = Long.parseLong(req.getParameter("id"));
        try {
            User user = this.authenticationSupport.getMe(req);
            this.servicesClient.deleteUserPhenotype(user.getId(), propId);
        }
        catch (ClientException e) {
            resp.setContentType("text/plain");
            switch (1.$SwitchMap$com$sun$jersey$api$client$ClientResponse$Status[e.getResponseStatus().ordinal()]) {
                case 1: {
                    this.authenticationSupport.needsToLogin(req, resp);
                    break;
                }
                case 2: {
                    resp.setStatus(500);
                    LOGGER.error("Error deleting phenotype " + propId, (Throwable)e);
                    ResourceBundle messages = (ResourceBundle)req.getAttribute("messages");
                    String msg = messages.getString("deletePhenotype.error.internalServerError");
                    resp.getWriter().write(msg);
                    break;
                }
                default: {
                    LOGGER.debug("Deleting phenotype {} failed", (Object)propId, (Object)e);
                    resp.setStatus(400);
                    resp.getWriter().write(e.getMessage());
                }
            }
        }
    }
}

