/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Phenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.PhenotypeVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.FrequencyType;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueComparator;
import edu.emory.cci.aiw.cvrg.eureka.common.exception.PhenotypeHandlingException;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditPropositionServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditPropositionServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditPropositionServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public EditPropositionServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String propKey = req.getParameter("key");
        Phenotype.Type propType = this.getPropTypeFromParam(req.getParameter("type"));
        try {
            List freqTypes = this.servicesClient.getFrequencyTypesAsc();
            FrequencyType defaultFreqType = null;
            for (FrequencyType freqType : freqTypes) {
                if (!freqType.isDefault()) continue;
                defaultFreqType = freqType;
                break;
            }
            List timeUnits = this.servicesClient.getTimeUnitsAsc();
            TimeUnit defaultTimeUnit = null;
            for (TimeUnit timeUnit : timeUnits) {
                if (!timeUnit.isDefault()) continue;
                defaultTimeUnit = timeUnit;
                break;
            }
            List relOps = this.servicesClient.getRelationOperatorsAsc();
            ArrayList<Object> sequentialRelOps = new ArrayList<Object>();
            ArrayList<Object> contextRelOps = new ArrayList<Object>();
            block21: for (Object relOp : relOps) {
                switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$entity$RelationOperator$Type[relOp.getType().ordinal()]) {
                    case 1: {
                        sequentialRelOps.add(relOp);
                    }
                    case 2: {
                        contextRelOps.add(relOp);
                        continue block21;
                    }
                }
                throw new AssertionError((Object)("Unexpected relation type: " + relOp));
            }
            RelationOperator defaultRelOp = null;
            for (RelationOperator relOp : relOps) {
                if (!relOp.isDefault()) continue;
                defaultRelOp = relOp;
                break;
            }
            List thresholdOps = this.servicesClient.getThresholdsOperators();
            List valueComparators = this.servicesClient.getValueComparatorsAsc();
            ArrayList<ValueComparator> valueCompsUpper = new ArrayList<ValueComparator>();
            ArrayList<ValueComparator> valueCompsLower = new ArrayList<ValueComparator>();
            block23: for (ValueComparator vc : valueComparators) {
                switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$entity$ValueComparator$Threshold[vc.getThreshold().ordinal()]) {
                    case 1: {
                        valueCompsUpper.add(vc);
                        valueCompsLower.add(vc);
                        continue block23;
                    }
                    case 2: {
                        valueCompsUpper.add(vc);
                        continue block23;
                    }
                    case 3: {
                        valueCompsLower.add(vc);
                        continue block23;
                    }
                }
                throw new AssertionError((Object)("Unexpected threshold: " + vc.getThreshold()));
            }
            req.setAttribute("timeUnits", (Object)timeUnits);
            req.setAttribute("sequentialRelationOps", sequentialRelOps);
            req.setAttribute("contextRelationOps", contextRelOps);
            req.setAttribute("thresholdsOperators", (Object)thresholdOps);
            req.setAttribute("valueComparatorsUpper", valueCompsUpper);
            req.setAttribute("valueComparatorsLower", valueCompsLower);
            req.setAttribute("defaultTimeUnit", (Object)defaultTimeUnit);
            req.setAttribute("defaultRelationOp", (Object)defaultRelOp);
            req.setAttribute("frequencyTypes", (Object)freqTypes);
            req.setAttribute("defaultFrequencyType", (Object)defaultFreqType);
            if (propKey != null && !propKey.equals("")) {
                Phenotype phenotype = this.servicesClient.getUserPhenotype(propKey, false);
                PropertiesPhenotypeVisitor visitor = new PropertiesPhenotypeVisitor(this.servicesClient, null);
                try {
                    LOGGER.debug("Visiting {}", (Object)phenotype.getKey());
                    phenotype.accept((PhenotypeVisitor)visitor);
                }
                catch (PhenotypeHandlingException e) {
                    LOGGER.error("Visiting {}", (Object)phenotype.getKey(), (Object)e);
                    throw new ServletException("Error getting phenotype properties", e.getCause());
                }
                req.setAttribute("properties", (Object)visitor.getProperties());
                req.setAttribute("proposition", (Object)phenotype);
                req.setAttribute("propositionType", (Object)phenotype.getType().toString());
                propType = phenotype.getType();
            }
            String jsp = null;
            switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$comm$Phenotype$Type[propType.ordinal()]) {
                case 1: {
                    jsp = "frequency";
                    break;
                }
                case 2: {
                    jsp = "categorization";
                    break;
                }
                case 3: {
                    jsp = "sequence";
                    break;
                }
                case 4: {
                    jsp = "value_threshold";
                }
            }
            if (jsp == null) {
                throw new ServletException("Unknown phenotype type");
            }
            req.getRequestDispatcher("/protected/" + jsp + ".jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ClientException ex) {
            throw new ServletException("Error setting up phenotype editor", (Throwable)ex);
        }
    }

    private Phenotype.Type getPropTypeFromParam(String inType) {
        Phenotype.Type type = null;
        if ("categorization".equals(inType)) {
            type = Phenotype.Type.CATEGORIZATION;
        } else if ("sequence".equals(inType)) {
            type = Phenotype.Type.SEQUENCE;
        } else if ("frequency".equals(inType)) {
            type = Phenotype.Type.FREQUENCY;
        } else if ("value_threshold".equals(inType)) {
            type = Phenotype.Type.VALUE_THRESHOLD;
        }
        return type;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

