/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LocalUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PasswordExpiredFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordExpiredFilter.class);
    private String redirectUrl;
    private String saveUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectUrl = filterConfig.getInitParameter("redirect-url");
        this.saveUrl = filterConfig.getInitParameter("save-url");
        if (this.redirectUrl == null) {
            throw new ServletException("Parameter redirect-url must be set");
        }
        if (this.saveUrl == null) {
            throw new ServletException("Parameter save-url must be set");
        }
        LOGGER.debug("redirect-url: {}", (Object)this.redirectUrl);
        LOGGER.debug("save-url: {}", (Object)this.saveUrl);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        User user = (User)request.getAttribute("user");
        if (!(user instanceof LocalUser)) {
            chain.doFilter(request, response);
        } else {
            Date now = new Date();
            Date expiration = ((LocalUser)user).getPasswordExpiration();
            LOGGER.debug("expiration date: {}", (Object)expiration);
            if (expiration != null && now.after(expiration)) {
                String targetUrl = servletRequest.getRequestURI();
                String fullRedirectUrl = servletRequest.getContextPath() + this.redirectUrl;
                String fullSaveUrl = servletRequest.getContextPath() + this.saveUrl;
                LOGGER.debug("fullRedirectUrl: {}", (Object)fullRedirectUrl);
                LOGGER.debug("fullSaveUrl: {}", (Object)fullSaveUrl);
                LOGGER.debug("targetUrl: {}", (Object)targetUrl);
                if (!targetUrl.equals(fullRedirectUrl) && !targetUrl.equals(fullSaveUrl)) {
                    String encodeRedirectURL = servletResponse.encodeRedirectURL(fullRedirectUrl + "?firstLogin=" + (user.getLastLogin() == null) + "&redirectURL=" + targetUrl);
                    LOGGER.debug("encodeRedirectURL: {}", (Object)encodeRedirectURL);
                    servletResponse.sendRedirect(encodeRedirectURL);
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public void destroy() {
    }
}

