/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.admin.EditUserWorker;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.admin.ListUsersWorker;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.admin.SaveUserWorker;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminManagerServlet
extends HttpServlet {
    private final ServicesClient servicesClient;

    @Inject
    public AdminManagerServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!req.isUserInRole("admin")) {
            resp.setStatus(401);
        } else {
            String action = req.getParameter("action");
            if (action == null) {
                resp.setStatus(400);
                resp.getWriter().write("The action parameter is required");
            } else {
                ListUsersWorker worker = null;
                if (action.equals("list")) {
                    worker = new ListUsersWorker(this.servicesClient);
                } else if (action.equals("edit")) {
                    worker = new EditUserWorker(this.servicesClient);
                } else if (action.equals("save")) {
                    worker = new SaveUserWorker(this.servicesClient);
                }
                if (null == worker) {
                    resp.setStatus(400);
                    resp.getWriter().write("Invalid action parameter " + action + ". Allowed values are list, edit and save.");
                } else {
                    worker.execute(req, resp);
                }
            }
        }
    }
}

