/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.useracct.ListUserAcctWorker;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.useracct.SaveUserAcctInfoWorker;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.useracct.SaveUserAcctWorker;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAcctManagerServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAcctManagerServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public UserAcctManagerServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ListUserAcctWorker worker;
        String action = req.getParameter("action");
        if (action != null && action.equals("savepassword")) {
            LOGGER.info("Saving user password");
            worker = new SaveUserAcctWorker(this.getServletContext(), this.servicesClient);
        } else if (action != null && action.equals("saveinfo")) {
            LOGGER.info("Saving user info");
            worker = new SaveUserAcctInfoWorker(this.getServletContext(), this.servicesClient);
        } else {
            LOGGER.info("Listing user");
            worker = new ListUserAcctWorker(this.servicesClient);
        }
        worker.execute(req, resp);
    }
}

