/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.Role;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.standardapis.filter.RolesRequestWrapper;

@Singleton
public class RolesFilter
implements Filter {
    private final ServicesClient client;

    @Inject
    public RolesFilter(ServicesClient inClient) {
        this.client = inClient;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        User user = (User)servletRequest.getAttribute("user");
        if (user != null) {
            try {
                HttpSession session = servletRequest.getSession(false);
                assert (session != null) : "session should not be null";
                Principal principal = servletRequest.getUserPrincipal();
                assert (principal != null) : "principal should not be null";
                HashSet userRoleIds = new HashSet(user.getRoles());
                List roles = this.client.getRoles();
                HashMap<Long, Object> idsToRoles = new HashMap<Long, Object>();
                for (Object role : roles) {
                    if (!userRoleIds.contains(role.getId())) continue;
                    idsToRoles.put(role.getId(), role);
                }
                HashSet<String> roleNames = new HashSet<String>();
                for (Map.Entry entry : idsToRoles.entrySet()) {
                    roleNames.add(((Role)entry.getValue()).getName());
                }
                RolesRequestWrapper wrappedRequest = new RolesRequestWrapper(servletRequest, principal, roleNames);
                inChain.doFilter((ServletRequest)wrappedRequest, inResponse);
            }
            catch (ClientException ce) {
                throw new ServletException((Throwable)ce);
            }
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    public void destroy() {
    }
}

