/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SystemPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

@Deprecated
public class SearchSystemPropositionServlet
extends HttpServlet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    private final ServicesClient servicesClient;

    @Inject
    public SearchSystemPropositionServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private JsonTreeData createData(SystemPhenotype phenotype) {
        JsonTreeData d = new JsonTreeData();
        d.setState("closed");
        d.setId(phenotype.getKey());
        d.setData(this.getDisplayName(phenotype));
        d.setText(this.getDisplayName(phenotype));
        d.setKeyVal("id", phenotype.getKey());
        String properties = StringUtils.join((Iterable)phenotype.getProperties(), (String)",");
        d.setKeyVal("data-properties", properties);
        d.setKeyVal("data-key", phenotype.getKey());
        d.setKeyVal("data-space", "system");
        d.setKeyVal("data-type", phenotype.getSystemType().toString());
        d.setKeyVal("data-proposition", phenotype.getKey());
        d.setChildren(false);
        return d;
    }

    private String getDisplayName(SystemPhenotype p) {
        String displayName = "";
        displayName = p.getDisplayName() != null && !p.getDisplayName().equals("") ? p.getDisplayName() + " (" + p.getKey() + ")" : p.getKey();
        return displayName;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String searchKey = req.getParameter("searchKey");
        ArrayList l = new ArrayList();
        if (searchKey == null) {
            throw new ServletException("Search key is null");
        }
        try {
            List processedSearchResult = null;
            List searchResult = null;
            searchResult = this.servicesClient.getSystemPhenotypeSearchResults(searchKey);
            processedSearchResult = this.convertResultsForJstreeRequirement(searchResult);
            resp.setContentType("application/json");
            PrintWriter out = resp.getWriter();
            MAPPER.writeValue((Writer)out, (Object)processedSearchResult);
        }
        catch (ClientException e) {
            throw new ServletException("Error getting search results", (Throwable)e);
        }
    }

    private List<String> convertResultsForJstreeRequirement(List<String> searchResult) {
        ArrayList<String> newResultSet = new ArrayList<String>();
        newResultSet.add("#root");
        for (String currentSearchResult : searchResult) {
            newResultSet.add("#" + PATTERN.matcher(currentSearchResult).replaceAll("\\\\$0"));
        }
        return newResultSet;
    }
}

