/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.common.comm.clients.ClientException;

public class LoginServlet
extends HttpServlet {
    private final ServicesClient servicesClient;

    @Inject
    public LoginServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            User user = (User)req.getAttribute("user");
            user.setLastLogin(new Date());
            this.servicesClient.updateUser(user, user.getId());
            resp.sendRedirect(req.getContextPath() + "/#/index");
        }
        catch (ClientException e) {
            ClientResponse.Status responseStatus = e.getResponseStatus();
            if (responseStatus == ClientResponse.Status.FORBIDDEN) {
                HttpSession session = req.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                resp.sendError(403);
            }
            throw new ServletException((Throwable)e);
        }
    }
}

