/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Phenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditorHomeServlet;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorHomeServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorHomeServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public EditorHomeServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    private JsonTreeData createData(String key, String data) {
        JsonTreeData d = new JsonTreeData();
        d.setData(data);
        d.setKeyVal("key", key);
        return d;
    }

    private String getDisplayName(Phenotype e) {
        String displayName = "";
        displayName = e.getDisplayName() != null && !e.getDisplayName().equals("") ? e.getDisplayName() + "(" + e.getKey() + ")" : e.getKey();
        return displayName;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List props;
        ArrayList<JsonTreeData> l = new ArrayList<JsonTreeData>();
        try {
            props = this.servicesClient.getUserPhenotypes(true);
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting user-defined phenotypes", (Throwable)ex);
        }
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        for (Phenotype proposition : props) {
            JsonTreeData d = this.createData(proposition.getKey(), this.getDisplayName(proposition));
            d.setKeyVal("description", proposition.getDescription());
            d.setKeyVal("displayName", proposition.getDisplayName());
            d.setKeyVal("id", proposition.getId().toString());
            if (null != proposition.getType()) {
                switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$comm$Phenotype$Type[proposition.getType().ordinal()]) {
                    case 1: {
                        d.setKeyVal("type", "Categorical");
                        break;
                    }
                    case 2: {
                        d.setKeyVal("type", "Sequence");
                        break;
                    }
                    case 3: {
                        d.setKeyVal("type", "Frequency");
                        break;
                    }
                    case 4: {
                        d.setKeyVal("type", "Value Threshold");
                        break;
                    }
                }
            }
            if (proposition.getCreated() != null) {
                LOGGER.debug("created date: " + df.format(proposition.getCreated()));
                d.setKeyVal("created", df.format(proposition.getCreated()));
            }
            if (proposition.getLastModified() != null) {
                d.setKeyVal("lastModified", df.format(proposition.getLastModified()));
            }
            l.add(d);
            LOGGER.debug("Added user prop: " + d.getData());
        }
        req.setAttribute("props", l);
        req.getRequestDispatcher("/protected/editor_home.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

