/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Phenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SystemPhenotype;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.PropositionListSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropositionListServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropositionListServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;
    private final PropositionListSupport propListSupport;

    @Inject
    public SystemPropositionListServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.propListSupport = new PropositionListSupport();
    }

    private JsonTreeData createData(SystemPhenotype phenotype) {
        JsonTreeData d = new JsonTreeData();
        d.setState("closed");
        d.setId(phenotype.getKey());
        d.setData(this.propListSupport.getDisplayName((Phenotype)phenotype));
        d.setText(this.propListSupport.getDisplayName((Phenotype)phenotype));
        d.setKeyVal("id", phenotype.getKey());
        String properties = StringUtils.join((Iterable)phenotype.getProperties(), (String)",");
        d.setKeyVal("data-properties", properties);
        d.setKeyVal("data-key", phenotype.getKey());
        d.setKeyVal("data-space", "system");
        d.setKeyVal("data-type", phenotype.getSystemType().toString());
        d.setKeyVal("data-proposition", phenotype.getKey());
        d.setChildren(phenotype.isInternalNode());
        return d;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<JsonTreeData> l;
        LOGGER.debug("doGet");
        String propKey = req.getParameter("key");
        if (propKey == null) {
            throw new ServletException("Invalid proposition id: " + propKey);
        }
        try {
            if (propKey.equals("root")) {
                List props = this.servicesClient.getSystemPhenotypes();
                l = new ArrayList<JsonTreeData>(props.size());
                for (SystemPhenotype proposition : props) {
                    JsonTreeData d = this.createData(proposition);
                    l.add(d);
                }
            } else {
                SystemPhenotype phenotype = this.servicesClient.getSystemPhenotype(propKey, false);
                List children = phenotype.getChildren();
                l = new ArrayList(children.size());
                for (SystemPhenotype propChild : children) {
                    JsonTreeData newData = this.createData(propChild);
                    newData.setType("system");
                    l.add(newData);
                }
            }
        }
        catch (ClientException e) {
            throw new ServletException("Error getting proposition list", (Throwable)e);
        }
        LOGGER.debug("executed resource get");
        resp.setContentType("application/json");
        PrintWriter out = resp.getWriter();
        MAPPER.writeValue((Writer)out, l);
    }
}

