/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.worker.useracct;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.ServletWorker;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveUserAcctInfoWorker
implements ServletWorker {
    private static Logger LOGGER = LoggerFactory.getLogger(SaveUserAcctInfoWorker.class);
    private final ResourceBundle messages;
    private final ServicesClient servicesClient;
    private final WebappProperties properties;

    public SaveUserAcctInfoWorker(ServletContext ctx, ServicesClient inClient) {
        String localizationContextName = ctx.getInitParameter("javax.servlet.jsp.jstl.fmt.localizationContext");
        this.messages = ResourceBundle.getBundle(localizationContextName);
        this.servicesClient = inClient;
        this.properties = new WebappProperties();
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("id");
        if (id != null && !id.isEmpty()) {
            String firstName = req.getParameter("firstName");
            String lastName = req.getParameter("lastName");
            String email = req.getParameter("email");
            String organization = req.getParameter("organization");
            String title = req.getParameter("title");
            String department = req.getParameter("department");
            String fullName = firstName + ' ' + lastName;
            User user = null;
            try {
                user = this.servicesClient.getUserById(Long.valueOf(id));
            }
            catch (ClientException ex) {
                LOGGER.error("Error getting user by id at {}", (Object)SaveUserAcctInfoWorker.class.getName(), (Object)ex);
                resp.setContentType("text/plain");
                resp.setStatus(400);
                resp.getWriter().write(ex.getMessage());
            }
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(email);
            user.setOrganization(organization);
            user.setTitle(title);
            user.setDepartment(department);
            user.setFullName(fullName);
            try {
                this.servicesClient.updateUser(user, Long.valueOf(id));
            }
            catch (ClientException ex) {
                LOGGER.error("Error updating user at {}", (Object)SaveUserAcctInfoWorker.class.getName(), (Object)ex);
                resp.setContentType("text/plain");
                resp.setStatus(400);
                resp.getWriter().write(ex.getMessage());
            }
            resp.setStatus(200);
        } else {
            LOGGER.error("Error getting user by id at {}, id is invalid", (Object)SaveUserAcctInfoWorker.class.getName());
            resp.setStatus(400);
        }
    }
}

