/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.RegisterUserServlet;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.LdapUserRequest;
import org.eurekaclinical.eureka.client.comm.LocalUserRequest;
import org.eurekaclinical.eureka.client.comm.OAuthUserRequest;
import org.eurekaclinical.eureka.client.comm.UserRequest;
import org.eurekaclinical.eureka.client.comm.authentication.AuthenticationMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterUserServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterUserServlet.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("Messages");
    private final ServicesClient servicesClient;

    @Inject
    public RegisterUserServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AuthenticationMethod authenticationMethod;
        String authenticationMethodStr = req.getParameter("authenticationMethod");
        try {
            authenticationMethod = AuthenticationMethod.valueOf((String)authenticationMethodStr);
        }
        catch (IllegalArgumentException ex) {
            throw new ServletException("Invalid authentication method: " + authenticationMethodStr);
        }
        try {
            LdapUserRequest userRequest;
            String username = req.getParameter("username");
            String email = req.getParameter("email");
            String verifyEmail = req.getParameter("verifyEmail");
            String firstName = req.getParameter("firstName");
            String lastName = req.getParameter("lastName");
            String organization = req.getParameter("organization");
            String title = req.getParameter("title");
            String department = req.getParameter("department");
            String fullName = req.getParameter("fullName");
            try {
                switch (1.$SwitchMap$org$eurekaclinical$eureka$client$comm$authentication$AuthenticationMethod[authenticationMethod.ordinal()]) {
                    case 1: {
                        String password = req.getParameter("password");
                        String verifyPassword = req.getParameter("verifyPassword");
                        LocalUserRequest localUserRequest = new LocalUserRequest();
                        localUserRequest.setVerifyPassword(verifyPassword);
                        localUserRequest.setPassword(password);
                        localUserRequest.setUsername(email);
                        userRequest = localUserRequest;
                        break;
                    }
                    case 2: {
                        userRequest = new LdapUserRequest();
                        userRequest.setUsername(username);
                        break;
                    }
                    case 3: {
                        String providerUsername = req.getParameter("providerUsername");
                        String oauthProvider = req.getParameter("oauthProvider");
                        OAuthUserRequest oauthUserRequest = new OAuthUserRequest();
                        oauthUserRequest.setUsername(username);
                        oauthUserRequest.setProviderUsername(providerUsername);
                        oauthUserRequest.setOAuthProvider(oauthProvider);
                        userRequest = oauthUserRequest;
                        break;
                    }
                    default: {
                        throw new ServletException("Unexpected authentication method: " + authenticationMethod);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new ServletException("Invalid authentication method: " + authenticationMethod);
            }
            if (fullName == null || fullName.trim().length() == 0) {
                fullName = MessageFormat.format(messages.getString("registerUserServlet.fullName"), firstName, lastName);
            }
            userRequest.setFirstName(firstName);
            userRequest.setLastName(lastName);
            userRequest.setEmail(email);
            userRequest.setVerifyEmail(verifyEmail);
            userRequest.setOrganization(organization);
            userRequest.setTitle(title);
            userRequest.setDepartment(department);
            userRequest.setFullName(fullName);
            this.servicesClient.addUser((UserRequest)userRequest);
            resp.setStatus(200);
        }
        catch (ClientException e) {
            String msg = e.getMessage();
            ClientResponse.Status responseStatus = e.getResponseStatus();
            switch (1.$SwitchMap$com$sun$jersey$api$client$ClientResponse$Status[responseStatus.ordinal()]) {
                case 1: {
                    resp.setStatus(409);
                    msg = messages.getString("registerUserServlet.error.conflict");
                    break;
                }
                case 2: {
                    resp.setStatus(400);
                    msg = messages.getString("registerUserServlet.error.badRequest");
                    break;
                }
                default: {
                    throw new ServletException();
                }
            }
            resp.setContentType("text/plain");
            LOGGER.debug("Error: {}", (Object)msg);
            resp.setContentLength(msg.length());
            resp.getWriter().write(msg);
        }
    }
}

