/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.oauth;

import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.PersonNameSplitter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.eureka.client.comm.authentication.AuthenticationMethod;
import org.eurekaclinical.scribeupext.profile.EurekaProfile;
import org.scribe.up.credential.OAuthCredential;
import org.scribe.up.provider.OAuthProvider;
import org.scribe.up.session.HttpUserSession;
import org.scribe.up.session.UserSession;

class RegistrationOAuthCallbackSupport<E extends EurekaProfile> {
    private final OAuthProvider provider;

    RegistrationOAuthCallbackSupport(OAuthProvider provider) {
        assert (provider != null) : "provider cannot be null";
        this.provider = provider;
    }

    E getProfile(HttpServletRequest req) {
        assert (req != null) : "request cannot be null";
        OAuthCredential credential = this.provider.getCredential((UserSession)new HttpUserSession(req.getSession()), req.getParameterMap());
        if (credential != null) {
            return (E)((EurekaProfile)this.provider.getUserProfile(credential));
        }
        return null;
    }

    boolean setEurekaAttributeFromProfile(HttpServletRequest req) {
        assert (req != null) : "request cannot be null";
        EurekaProfile userProfile = this.getProfile(req);
        if (userProfile != null) {
            req.setAttribute("accountTypeDisplayName", (Object)userProfile.getType());
            req.setAttribute("authenticationMethod", (Object)AuthenticationMethod.OAUTH.name());
            req.setAttribute("oauthProvider", (Object)this.provider.getType());
            String fullName = userProfile.getDisplayName();
            req.setAttribute("fullName", (Object)fullName);
            String firstName = userProfile.getFirstName();
            String lastName = userProfile.getFamilyName();
            if ((firstName == null || lastName == null) && fullName != null) {
                PersonNameSplitter splitter = new PersonNameSplitter(fullName);
                if (firstName == null) {
                    firstName = splitter.getFirstName();
                }
                if (lastName == null) {
                    lastName = splitter.getLastName();
                }
            }
            req.setAttribute("firstName", (Object)firstName);
            req.setAttribute("lastName", (Object)lastName);
            req.setAttribute("email", (Object)userProfile.getEmail());
            req.setAttribute("username", (Object)userProfile.getTypedId());
            req.setAttribute("providerUsername", (Object)userProfile.getUsername());
            return true;
        }
        return false;
    }

    void forwardProfileToRegisterPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.setEurekaAttributeFromProfile(req)) {
            req.getRequestDispatcher("/register.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            resp.sendRedirect(req.getContextPath() + "/chooseaccounttype");
        }
    }
}

