/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.authentication.WebappAuthenticationSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServlet.class);
    private final ServicesClient servicesClient;
    private final WebappAuthenticationSupport authenticationSupport;
    protected String targetUri;
    protected URI targetUriObj;
    protected static final String P_TARGET_URI = "targetUri";

    @Inject
    public ProxyServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.authenticationSupport = new WebappAuthenticationSupport(this.servicesClient);
    }

    protected String getConfigParam(String key) {
        return this.getServletConfig().getInitParameter(key);
    }

    public void init() throws ServletException {
        this.targetUri = this.getConfigParam(P_TARGET_URI);
        if (this.targetUri == null) {
            throw new ServletException("targetUri is required.");
        }
        try {
            this.targetUriObj = new URI(this.targetUri);
        }
        catch (Exception e) {
            throw new ServletException("Trying to process targetUri init parameter: " + e, (Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        LOGGER.debug("ProxyServlet - PUT");
        StringBuilder stringBuilder = new StringBuilder(1000);
        Scanner scanner = new Scanner((InputStream)servletRequest.getInputStream());
        while (scanner.hasNextLine()) {
            stringBuilder.append(scanner.nextLine());
        }
        LOGGER.debug("json: {}", (Object)stringBuilder.toString());
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri());
        if (servletRequest.getPathInfo() != null) {
            uri.append(servletRequest.getPathInfo());
        }
        LOGGER.debug("uri: {}", (Object)uri.toString());
        try {
            this.servicesClient.proxyPut(uri.toString(), stringBuilder.toString());
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        LOGGER.debug("ProxyServlet - POST");
        StringBuilder stringBuilder = new StringBuilder(1000);
        Scanner scanner = new Scanner((InputStream)servletRequest.getInputStream());
        while (scanner.hasNextLine()) {
            stringBuilder.append(scanner.nextLine());
        }
        LOGGER.debug("json: {}", (Object)stringBuilder.toString());
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri());
        if (servletRequest.getPathInfo() != null) {
            uri.append(servletRequest.getPathInfo());
        }
        LOGGER.debug("uri: {}", (Object)uri.toString());
        try {
            this.servicesClient.proxyPost(uri.toString(), stringBuilder.toString());
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        LOGGER.debug("ProxyServlet - DELETE");
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri());
        if (servletRequest.getPathInfo() != null) {
            uri.append(servletRequest.getPathInfo());
        }
        LOGGER.debug("uri: {}", (Object)uri.toString());
        try {
            this.servicesClient.proxyDelete(uri.toString());
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    public String getTargetUri() {
        return this.targetUri;
    }
}

