/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.LocalUser;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.webapp.authentication.WebappAuthenticationSupport;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PasswordExpiredFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordExpiredFilter.class);
    private final ServicesClient servicesClient;
    private final WebappAuthenticationSupport authenticationSupport;
    private String redirectUrl;
    private String saveUrl;

    @Inject
    public PasswordExpiredFilter(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.authenticationSupport = new WebappAuthenticationSupport(this.servicesClient);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectUrl = filterConfig.getInitParameter("redirect-url");
        this.saveUrl = filterConfig.getInitParameter("save-url");
        if (this.redirectUrl == null) {
            throw new ServletException("Parameter redirect-url must be set");
        }
        if (this.saveUrl == null) {
            throw new ServletException("Parameter save-url must be set");
        }
        LOGGER.debug("redirect-url: {}", (Object)this.redirectUrl);
        LOGGER.debug("save-url: {}", (Object)this.saveUrl);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            String name = servletRequest.getRemoteUser();
            LOGGER.debug("username: {}", (Object)name);
            User user = (User)request.getAttribute("user");
            if (!(user instanceof LocalUser)) {
                chain.doFilter(request, response);
            } else {
                Date now = new Date();
                Date expiration = ((LocalUser)user).getPasswordExpiration();
                LOGGER.debug("expiration date: {}", (Object)expiration);
                if (expiration != null && now.after(expiration)) {
                    String targetUrl = servletRequest.getRequestURI();
                    String fullRedirectUrl = servletRequest.getContextPath() + this.redirectUrl;
                    String fullSaveUrl = servletRequest.getContextPath() + this.saveUrl;
                    LOGGER.debug("fullRedirectUrl: {}", (Object)fullRedirectUrl);
                    LOGGER.debug("fullSaveUrl: {}", (Object)fullSaveUrl);
                    LOGGER.debug("targetUrl: {}", (Object)targetUrl);
                    if (!targetUrl.equals(fullRedirectUrl) && !targetUrl.equals(fullSaveUrl)) {
                        servletResponse.sendRedirect(fullRedirectUrl + "?firstLogin=" + (user.getLastLogin() == null) + "&redirectURL=" + targetUrl);
                    } else {
                        chain.doFilter(request, response);
                    }
                } else {
                    chain.doFilter(request, response);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

