/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElementVisitor;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.FrequencyType;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.RelationOperator;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.TimeUnit;
import edu.emory.cci.aiw.cvrg.eureka.common.entity.ValueComparator;
import edu.emory.cci.aiw.cvrg.eureka.common.exception.DataElementHandlingException;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.EditPropositionServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditPropositionServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditPropositionServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public EditPropositionServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String propKey = req.getParameter("key");
        DataElement.Type propType = this.getPropTypeFromParam(req.getParameter("type"));
        try {
            List freqTypes = this.servicesClient.getFrequencyTypesAsc();
            FrequencyType defaultFreqType = this.servicesClient.getDefaultFrequencyType();
            List timeUnits = this.servicesClient.getTimeUnitsAsc();
            TimeUnit defaultTimeUnit = this.servicesClient.getDefaultTimeUnit();
            List relOps = this.servicesClient.getRelationOperatorsAsc();
            ArrayList<RelationOperator> sequentialRelOps = new ArrayList<RelationOperator>();
            ArrayList<RelationOperator> contextRelOps = new ArrayList<RelationOperator>();
            block19: for (RelationOperator relOp : relOps) {
                switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$entity$RelationOperator$Type[relOp.getType().ordinal()]) {
                    case 1: {
                        sequentialRelOps.add(relOp);
                    }
                    case 2: {
                        contextRelOps.add(relOp);
                        continue block19;
                    }
                }
                throw new AssertionError((Object)("Unexpected relation type: " + relOp));
            }
            RelationOperator defaultRelOp = this.servicesClient.getDefaultRelationOperator();
            List thresholdOps = this.servicesClient.getThresholdsOperators();
            List valueComparators = this.servicesClient.getValueComparatorsAsc();
            ArrayList<ValueComparator> valueCompsUpper = new ArrayList<ValueComparator>();
            ArrayList<ValueComparator> valueCompsLower = new ArrayList<ValueComparator>();
            block20: for (ValueComparator vc : valueComparators) {
                switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$entity$ValueComparator$Threshold[vc.getThreshold().ordinal()]) {
                    case 1: {
                        valueCompsUpper.add(vc);
                        valueCompsLower.add(vc);
                        continue block20;
                    }
                    case 2: {
                        valueCompsUpper.add(vc);
                        continue block20;
                    }
                    case 3: {
                        valueCompsLower.add(vc);
                        continue block20;
                    }
                }
                throw new AssertionError((Object)("Unexpected threshold: " + vc.getThreshold()));
            }
            req.setAttribute("timeUnits", (Object)timeUnits);
            req.setAttribute("sequentialRelationOps", sequentialRelOps);
            req.setAttribute("contextRelationOps", contextRelOps);
            req.setAttribute("thresholdsOperators", (Object)thresholdOps);
            req.setAttribute("valueComparatorsUpper", valueCompsUpper);
            req.setAttribute("valueComparatorsLower", valueCompsLower);
            req.setAttribute("defaultTimeUnit", (Object)defaultTimeUnit);
            req.setAttribute("defaultRelationOp", (Object)defaultRelOp);
            req.setAttribute("frequencyTypes", (Object)freqTypes);
            req.setAttribute("defaultFrequencyType", (Object)defaultFreqType);
            if (propKey != null && !propKey.equals("")) {
                DataElement dataElement = this.servicesClient.getUserElement(propKey, false);
                PropertiesDataElementVisitor visitor = new PropertiesDataElementVisitor(this.servicesClient, null);
                try {
                    LOGGER.debug("Visiting {}", (Object)dataElement.getKey());
                    dataElement.accept((DataElementVisitor)visitor);
                }
                catch (DataElementHandlingException e) {
                    LOGGER.error("Visiting {}", (Object)dataElement.getKey(), (Object)e);
                    throw new ServletException("Error getting data element properties", e.getCause());
                }
                req.setAttribute("properties", (Object)visitor.getProperties());
                req.setAttribute("proposition", (Object)dataElement);
                req.setAttribute("propositionType", (Object)dataElement.getType().toString());
                propType = dataElement.getType();
            }
            String jsp = null;
            switch (1.$SwitchMap$edu$emory$cci$aiw$cvrg$eureka$common$comm$DataElement$Type[propType.ordinal()]) {
                case 1: {
                    jsp = "frequency";
                    break;
                }
                case 2: {
                    jsp = "categorization";
                    break;
                }
                case 3: {
                    jsp = "sequence";
                    break;
                }
                case 4: {
                    jsp = "value_threshold";
                }
            }
            if (jsp == null) {
                throw new ServletException("Unknown data element type");
            }
            req.getRequestDispatcher("/protected/" + jsp + ".jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ClientException ex) {
            throw new ServletException("Error setting up data element editor", (Throwable)ex);
        }
    }

    private DataElement.Type getPropTypeFromParam(String inType) {
        DataElement.Type type = null;
        if ("categorization".equals(inType)) {
            type = DataElement.Type.CATEGORIZATION;
        } else if ("sequence".equals(inType)) {
            type = DataElement.Type.SEQUENCE;
        } else if ("frequency".equals(inType)) {
            type = DataElement.Type.FREQUENCY;
        } else if ("value_threshold".equals(inType)) {
            type = DataElement.Type.VALUE_THRESHOLD;
        }
        return type;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

