/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.worker.admin;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.User;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.ServletWorker;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaveUserWorker
implements ServletWorker {
    private final ServicesClient servicesClient;

    public SaveUserWorker(ServicesClient inServicesClient) {
        this.servicesClient = inServicesClient;
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = req.getParameter("id");
        String activeStatus = req.getParameter("active");
        boolean isActivated = false;
        if (activeStatus != null) {
            isActivated = true;
        }
        try {
            User user = this.servicesClient.getUserById(Long.valueOf(id));
            String[] roles = req.getParameterValues("role");
            ArrayList<Long> userRoles = new ArrayList<Long>();
            if (roles != null) {
                for (String roleId : roles) {
                    try {
                        userRoles.add(Long.valueOf(roleId));
                    }
                    catch (NumberFormatException nfe) {
                        throw new ServletException((Throwable)nfe);
                    }
                }
            }
            user.setRoles(userRoles);
            user.setActive(isActivated);
            this.servicesClient.updateUser(user);
        }
        catch (ClientException e) {
            throw new ServletException("Error saving user", (Throwable)e);
        }
        resp.sendRedirect(req.getContextPath() + "/protected/admin?action=list");
    }
}

