/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.SavePropositionServlet;
import edu.emory.cci.aiw.cvrg.eureka.webapp.authentication.WebappAuthenticationSupport;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Phenotype;
import org.eurekaclinical.eureka.client.comm.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavePropositionServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SavePropositionServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;
    private final WebappAuthenticationSupport authenticationSupport;

    @Inject
    public SavePropositionServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.authenticationSupport = new WebappAuthenticationSupport(this.servicesClient);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block9: {
            LOGGER.debug("SavePropositionServlet");
            Phenotype phenotype = (Phenotype)MAPPER.readValue((Reader)req.getReader(), Phenotype.class);
            try {
                User user = this.authenticationSupport.getMe(req);
                phenotype.setUserId(user.getId());
                if (phenotype.getId() == null) {
                    try {
                        URI phenotypeURI = this.servicesClient.saveUserPhenotype(phenotype);
                        if (phenotypeURI != null) {
                            resp.setStatus(201);
                            resp.setHeader("Location", phenotypeURI.toString());
                        }
                        break block9;
                    }
                    catch (ClientException e) {
                        resp.setStatus(e.getResponseStatus().getStatusCode());
                        resp.getOutputStream().print(e.getMessage());
                    }
                    break block9;
                }
                this.servicesClient.updateUserPhenotype(phenotype.getId(), phenotype);
            }
            catch (ClientException e) {
                switch (1.$SwitchMap$com$sun$jersey$api$client$ClientResponse$Status[e.getResponseStatus().ordinal()]) {
                    case 1: {
                        this.authenticationSupport.needsToLogin(req, resp);
                        break;
                    }
                    default: {
                        resp.setStatus(e.getResponseStatus().getStatusCode());
                        resp.getWriter().write(e.getMessage());
                    }
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }
}

