/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.scribeupext.provider.GitHubProvider;
import org.eurekaclinical.scribeupext.provider.GlobusProvider;
import org.eurekaclinical.scribeupext.provider.Google2Provider;
import org.eurekaclinical.scribeupext.provider.SSLTwitterProvider;
import org.scribe.up.session.HttpUserSession;
import org.scribe.up.session.UserSession;

public class ChooseAccountTypeServlet
extends HttpServlet {
    private final WebappProperties properties;
    private final Google2Provider googleProvider;
    private final SSLTwitterProvider twitterProvider;
    private final GlobusProvider globusProvider;
    private final GitHubProvider gitHubProvider;

    @Inject
    public ChooseAccountTypeServlet(WebappProperties inProperties, Google2Provider inGoogleProvider, GitHubProvider inGitHubProvider, SSLTwitterProvider inTwitterProvider, GlobusProvider inGlobusProvider) {
        this.properties = inProperties;
        this.googleProvider = inGoogleProvider;
        this.twitterProvider = inTwitterProvider;
        this.globusProvider = inGlobusProvider;
        this.gitHubProvider = inGitHubProvider;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean oauthRegistrationEnabled = this.properties.isOAuthRegistrationEnabled();
        req.setAttribute("oauthRegistrationEnabled", (Object)oauthRegistrationEnabled);
        boolean localAccountRegistrationEnabled = this.properties.isLocalAccountRegistrationEnabled();
        if (oauthRegistrationEnabled) {
            HttpUserSession userSession = new HttpUserSession(req);
            String authorizationUrl = null;
            int countEnabled = 0;
            boolean googleAuthEnabled = this.properties.isGoogleOAuthRegistrationEnabled();
            req.setAttribute("googleAuthEnabled", (Object)googleAuthEnabled);
            if (googleAuthEnabled) {
                authorizationUrl = this.googleProvider.getAuthorizationUrl((UserSession)userSession);
                req.setAttribute("Google2ProviderUrl", (Object)authorizationUrl);
                ++countEnabled;
            }
            boolean gitHubAuthEnabled = this.properties.isGitHubOAuthRegistrationEnabled();
            req.setAttribute("gitHubAuthEnabled", (Object)gitHubAuthEnabled);
            if (gitHubAuthEnabled) {
                authorizationUrl = this.gitHubProvider.getAuthorizationUrl((UserSession)userSession);
                req.setAttribute("GitHubProviderUrl", (Object)authorizationUrl);
                ++countEnabled;
            }
            boolean twitterAuthEnabled = this.properties.isTwitterOAuthRegistrationEnabled();
            req.setAttribute("twitterAuthEnabled", (Object)twitterAuthEnabled);
            if (twitterAuthEnabled) {
                authorizationUrl = this.twitterProvider.getAuthorizationUrl((UserSession)userSession);
                req.setAttribute("SSLTwitterProviderUrl", (Object)authorizationUrl);
                ++countEnabled;
            }
            boolean globusAuthEnabled = this.properties.isGlobusOAuthRegistrationEnabled();
            req.setAttribute("globusAuthEnabled", (Object)globusAuthEnabled);
            if (globusAuthEnabled) {
                authorizationUrl = this.globusProvider.getAuthorizationUrl((UserSession)userSession);
                req.setAttribute("GlobusProviderUrl", (Object)authorizationUrl);
                ++countEnabled;
            }
            if (countEnabled == 1 && !localAccountRegistrationEnabled) {
                resp.sendRedirect(authorizationUrl);
                return;
            }
        }
        if (localAccountRegistrationEnabled && !oauthRegistrationEnabled) {
            resp.sendRedirect(req.getContextPath() + "/register.jsp");
        } else {
            if (!localAccountRegistrationEnabled && !oauthRegistrationEnabled) {
                throw new ServletException("Registration is disabled");
            }
            req.setAttribute("localAccountRegistrationEnabled", (Object)localAccountRegistrationEnabled);
            req.getRequestDispatcher("/choose_account_type.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

