/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProxyServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServlet.class);
    private final ServicesClient servicesClient;
    protected URI targetUri;
    protected static final String P_TARGET_URI = "targetUri";

    @Inject
    public ProxyServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
    }

    public void init() throws ServletException {
        String targetUriStr = this.getServletConfig().getInitParameter("targetUri");
        if (targetUriStr == null) {
            throw new ServletException("targetUri is required.");
        }
        try {
            this.targetUri = new URI(targetUriStr);
        }
        catch (Exception e) {
            throw new ServletException("Trying to process targetUri init parameter: " + e, (Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - PUT");
        String content = ProxyServlet.extractContent((HttpServletRequest)servletRequest);
        String uri = this.doRoute(servletRequest);
        try {
            this.servicesClient.proxyPut(uri, content);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - POST");
        String content = ProxyServlet.extractContent((HttpServletRequest)servletRequest);
        String uri = this.doRoute(servletRequest);
        try {
            URI created = this.servicesClient.proxyPost(uri, content);
            if (created != null) {
                servletResponse.setStatus(201);
                servletResponse.setHeader("Location", created.toString());
            }
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - DELETE");
        String uri = this.doRoute(servletRequest);
        try {
            this.servicesClient.proxyDelete(uri);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        LOGGER.debug("ProxyServlet - GET");
        String uri = this.doRoute(servletRequest);
        try {
            Map parameterMap = servletRequest.getParameterMap();
            MultivaluedMap multivaluedMap = ProxyServlet.toMultivaluedMap((Map)parameterMap);
            String response = this.servicesClient.proxyGet(uri, multivaluedMap);
            servletResponse.getWriter().write(response);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    private String doRoute(HttpServletRequest servletRequest) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.targetUri);
        String pathInfo = servletRequest.getPathInfo();
        if (pathInfo != null) {
            uriBuilder = uriBuilder.path(pathInfo);
        }
        String uri = uriBuilder.build(new Object[0]).toString();
        LOGGER.debug("uri: {}", (Object)uri);
        return uri;
    }

    private static MultivaluedMap toMultivaluedMap(Map<String, String[]> inQueryParameters) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        for (Map.Entry<String, String[]> parameter : inQueryParameters.entrySet()) {
            String[] values;
            for (String value : values = parameter.getValue()) {
                queryParams.add((Object)parameter.getKey(), (Object)value);
            }
        }
        return queryParams;
    }

    private static String extractContent(HttpServletRequest servletRequest) throws IOException {
        ServletInputStream inputStream = servletRequest.getInputStream();
        String charEncoding = servletRequest.getCharacterEncoding();
        String content = IOUtils.toString((InputStream)inputStream, (String)charEncoding);
        LOGGER.debug("json: {}", (Object)content);
        return content;
    }
}

