/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.SystemElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.PropositionListSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropositionListServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropositionListServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;
    private final PropositionListSupport propListSupport;

    @Inject
    public SystemPropositionListServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.propListSupport = new PropositionListSupport();
    }

    private JsonTreeData createData(SystemElement element) {
        JsonTreeData d = new JsonTreeData();
        d.setState("closed");
        d.setId(element.getKey());
        d.setData(this.propListSupport.getDisplayName((DataElement)element));
        d.setText(this.propListSupport.getDisplayName((DataElement)element));
        d.setKeyVal("id", element.getKey());
        String properties = StringUtils.join((Iterable)element.getProperties(), (String)",");
        d.setKeyVal("data-properties", properties);
        d.setKeyVal("data-key", element.getKey());
        d.setKeyVal("data-space", "system");
        d.setKeyVal("data-type", element.getSystemType().toString());
        d.setKeyVal("data-proposition", element.getKey());
        d.setChildren(element.isInternalNode());
        return d;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<JsonTreeData> l;
        LOGGER.debug("doGet");
        String propKey = req.getParameter("key");
        if (propKey == null) {
            throw new ServletException("Invalid proposition id: " + propKey);
        }
        try {
            if (propKey.equals("root")) {
                List props = this.servicesClient.getSystemElements();
                l = new ArrayList<JsonTreeData>(props.size());
                for (SystemElement proposition : props) {
                    JsonTreeData d = this.createData(proposition);
                    l.add(d);
                }
            } else {
                SystemElement element = this.servicesClient.getSystemElement(propKey, false);
                List children = element.getChildren();
                l = new ArrayList(children.size());
                for (SystemElement propChild : children) {
                    JsonTreeData newData = this.createData(propChild);
                    newData.setType("system");
                    l.add(newData);
                }
            }
        }
        catch (ClientException e) {
            throw new ServletException("Error getting proposition list", (Throwable)e);
        }
        LOGGER.debug("executed resource get");
        resp.setContentType("application/json");
        PrintWriter out = resp.getWriter();
        MAPPER.writeValue((Writer)out, l);
    }
}

