/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.proposition;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.Category;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.DataElement;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.PropositionListSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPropositionListServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPropositionListServlet.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ServicesClient servicesClient;
    private final PropositionListSupport propListSupport;

    @Inject
    public UserPropositionListServlet(ServicesClient inClient) {
        this.servicesClient = inClient;
        this.propListSupport = new PropositionListSupport();
    }

    private JsonTreeData createData(DataElement element) {
        JsonTreeData d = new JsonTreeData();
        d.setData(this.propListSupport.getDisplayName(element));
        d.setText(this.propListSupport.getDisplayName(element));
        d.setKeyVal("id", String.valueOf(element.getId()));
        d.setKeyVal("data-key", element.getKey());
        d.setKeyVal("data-space", "user");
        d.setKeyVal("data-type", element.getType().toString());
        if (element.getType() == DataElement.Type.CATEGORIZATION) {
            d.setKeyVal("data-subtype", ((Category)element).getCategoricalType().toString());
        }
        return d;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List props;
        LOGGER.debug("doGet");
        try {
            props = this.servicesClient.getUserElements(false);
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting user-defined data element list", (Throwable)ex);
        }
        ArrayList<JsonTreeData> l = new ArrayList<JsonTreeData>(props.size());
        for (DataElement proposition : props) {
            JsonTreeData d = this.createData(proposition);
            l.add(d);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Added user prop: {}", (Object)d.getData());
        }
        LOGGER.debug("executed resource get");
        resp.setContentType("application/json");
        PrintWriter out = resp.getWriter();
        MAPPER.writeValue((Writer)out, l);
    }
}

