/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.worker.useracct;

import com.sun.jersey.api.client.ClientResponse;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ClientException;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.ServletWorker;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveUserAcctWorker
implements ServletWorker {
    private static Logger LOGGER = LoggerFactory.getLogger(SaveUserAcctWorker.class);
    private final ResourceBundle messages;
    private final ServicesClient servicesClient;
    private final WebappProperties properties;

    public SaveUserAcctWorker(ServletContext ctx, ServicesClient inClient) {
        String localizationContextName = ctx.getInitParameter("javax.servlet.jsp.jstl.fmt.localizationContext");
        this.messages = ResourceBundle.getBundle(localizationContextName);
        this.servicesClient = inClient;
        this.properties = new WebappProperties();
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String oldPassword = req.getParameter("oldPassword");
        String newPassword = req.getParameter("newPassword");
        String verifyPassword = req.getParameter("verifyPassword");
        if (!verifyPassword.equals(newPassword)) {
            resp.setContentType("text/html");
            resp.setStatus(400);
            return;
        }
        resp.setContentType("text/html");
        try {
            this.servicesClient.changePassword(oldPassword, newPassword);
            resp.setStatus(200);
            resp.getWriter().write(200);
        }
        catch (ClientException e) {
            LOGGER.error("Error trying to change password for user {}", (Object)req.getUserPrincipal().getName(), (Object)e);
            resp.setContentType("text/plain");
            if (ClientResponse.Status.PRECONDITION_FAILED.equals((Object)e.getResponseStatus())) {
                resp.setStatus(400);
                resp.getWriter().write(e.getMessage());
            }
            resp.setStatus(500);
            resp.getWriter().write(this.messages.getString("passwordChange.error.internalServerError"));
        }
    }
}

