/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.worker.admin;

import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.worker.ServletWorker;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.clients.ClientException;

public class ListUsersWorker
implements ServletWorker {
    private final ServicesClient servicesClient;

    public ListUsersWorker(ServicesClient inServicesClient) {
        this.servicesClient = inServicesClient;
    }

    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        List roles;
        List users;
        try {
            users = this.servicesClient.getUsers();
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting user list", (Throwable)ex);
        }
        try {
            roles = this.servicesClient.getRoles();
        }
        catch (ClientException ex) {
            throw new ServletException("Error getting role list", (Throwable)ex);
        }
        HashMap<Long, Role> rolesMap = new HashMap<Long, Role>();
        for (Role role : roles) {
            rolesMap.put(role.getId(), role);
        }
        Collections.sort(users, new /* Unavailable Anonymous Inner Class!! */);
        req.setAttribute("users", (Object)users);
        req.setAttribute("roles", rolesMap);
        req.getRequestDispatcher("/protected/admin.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

