/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.cohort;

import com.google.inject.Inject;
import edu.emory.cci.aiw.cvrg.eureka.common.comm.clients.ServicesClient;
import edu.emory.cci.aiw.cvrg.eureka.servlet.proposition.JsonTreeData;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.eureka.client.comm.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CohortHomeServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CohortHomeServlet.class);
    private final ServicesClient servicesClient;

    @Inject
    public CohortHomeServlet(ServicesClient cohortsClient) {
        this.servicesClient = cohortsClient;
    }

    private JsonTreeData createData(String key, String data) {
        JsonTreeData d = new JsonTreeData();
        d.setData(data);
        d.setKeyVal("key", key);
        return d;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<JsonTreeData> cohortList = new ArrayList<JsonTreeData>();
        try {
            DateFormat df = DateFormat.getDateInstance(3);
            List destinations = this.servicesClient.getCohortDestinations();
            for (Destination dest : destinations) {
                JsonTreeData cohortJson = this.createData(dest.getName(), dest.getName());
                cohortJson.setKeyVal("displayName", dest.getName());
                cohortJson.setKeyVal("description", dest.getDescription());
                Date createdAt = dest.getCreatedAt();
                cohortJson.setKeyVal("createdDate", createdAt != null ? df.format(createdAt) : null);
                Date updatedAt = dest.getUpdatedAt();
                cohortJson.setKeyVal("lastModifiedDate", updatedAt != null ? df.format(updatedAt) : null);
                cohortList.add(cohortJson);
            }
        }
        catch (ClientException ex) {
            throw new ServletException((Throwable)ex);
        }
        req.setAttribute("cohorts", cohortList);
        req.getRequestDispatcher("/protected/cohort_home.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

