/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet.filter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.emory.cci.aiw.cvrg.eureka.servlet.filter.UserFilter;
import edu.emory.cci.aiw.cvrg.eureka.webapp.config.WebappProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.user.client.EurekaClinicalUserProxyClient;
import org.eurekaclinical.user.client.comm.User;

@Singleton
public class UserFilter
implements Filter {
    private final EurekaClinicalUserProxyClient inUserClient;
    private final WebappProperties properties;

    @Inject
    public UserFilter(EurekaClinicalUserProxyClient inToUserClient, WebappProperties inProperties) {
        this.inUserClient = inToUserClient;
        this.properties = inProperties;
    }

    public void init(FilterConfig inFilterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        block13: {
            HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
            HttpServletResponse servletResponse = (HttpServletResponse)inResponse;
            String remoteUser = servletRequest.getRemoteUser();
            inRequest.setAttribute("userWebappURL", (Object)this.properties.getUserWebappUrl());
            inRequest.setAttribute("userServiceURL", (Object)this.properties.getUserServiceUrl());
            Boolean userIsActive = true;
            if (!StringUtils.isEmpty((CharSequence)remoteUser)) {
                try {
                    HttpSession session = servletRequest.getSession(false);
                    if (session != null) {
                        User user = this.inUserClient.getMe();
                        userIsActive = this.inUserClient.getMe().isActive();
                        if (!userIsActive.booleanValue()) {
                            session.invalidate();
                            this.sendForbiddenError(servletResponse, servletRequest, true);
                        } else {
                            inRequest.setAttribute("user", (Object)user);
                            inRequest.setAttribute("userIsActivated", (Object)userIsActive);
                            inFilterChain.doFilter(inRequest, inResponse);
                        }
                        break block13;
                    }
                    this.goHome(servletRequest, servletResponse);
                }
                catch (ClientException ex) {
                    if (null != ex.getResponseStatus()) {
                        switch (1.$SwitchMap$com$sun$jersey$api$client$ClientResponse$Status[ex.getResponseStatus().ordinal()]) {
                            case 1: {
                                HttpSession session = servletRequest.getSession(false);
                                if (session != null) {
                                    session.invalidate();
                                }
                                this.sendForbiddenError(servletResponse, servletRequest, false);
                                break;
                            }
                            case 2: {
                                HttpSession session = servletRequest.getSession(false);
                                if (session != null) {
                                    session.invalidate();
                                }
                                this.goHome(servletRequest, servletResponse);
                                break;
                            }
                            default: {
                                throw new ServletException("Error getting user " + servletRequest.getRemoteUser(), (Throwable)ex);
                            }
                        }
                    }
                    break block13;
                }
            }
            inFilterChain.doFilter(inRequest, inResponse);
        }
    }

    private void goHome(HttpServletRequest inRequest, HttpServletResponse inResponse) throws IOException {
        inResponse.sendRedirect(inRequest.getContextPath() + "/logout?goHome=true");
    }

    private void sendForbiddenError(HttpServletResponse servletResponse, HttpServletRequest servletRequest, boolean created) throws IOException {
        if (this.properties.isRegistrationEnabled()) {
            servletResponse.setStatus(403);
            if (created) {
                servletResponse.sendRedirect(servletRequest.getContextPath() + "/logout?awaitingActivation=true");
            } else {
                servletResponse.sendRedirect(servletRequest.getContextPath() + "/logout?notRegistered=true");
            }
        } else {
            servletResponse.sendError(403);
        }
    }

    public void destroy() {
    }
}

