'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc overview
     * @name index
     * @description
     *
     * # Eureka Documentation
     *
     * Do you need help understanding the project structure or what services and directives you have available to you
     * in the Eureka Angular application? You've come to the right place!
     *
     * ## How to use this documentation
     *
     * This code-base is self-documenting; this documentation is automatically generated from comments left throughout
     * the code. If there is a problem with it, it is because the comments in the code were not updated.
     *
     * This project is broken down into several modules. Each module represents a section of the application. Inside
     * each module you will find views, directives, and services specific to that module. This allows you to bite off
     * code changes in smaller pieces and keeps everything organized in a sane manner.
     */

    /**
     * @ngdoc overview
     * @name eureka
     * @description
     * The main module for the Eureka Angular app.
     * @requires ui.router
     * @requires ui.tree
     * @requires angularValidator
     * @requires cohorts
     * @requires phenotypes
     * @requires register
     */
    angular.module('eureka', ['ui.router', 'ui.bootstrap', 'ui.tree', 'angularValidator', 'ngMessages', 'ui.grid', 'ui.grid.pagination', 'ngTable', 'eureka.cohorts', 'eureka.phenotypes', 'eureka.help', 'eureka.jobs', 'flow']);

    angular.module('eureka').run(eurekaRun);
    angular.module('eureka').config(eurekaConfig);

    eurekaRun.$inject = ['$rootScope', 'AppPropertiesService', 'appProperties', 'users'];
    eurekaConfig.$inject = ['$stateProvider', '$urlRouterProvider', '$httpProvider'];

    function eurekaRun($rootScope, AppPropertiesService, appProperties, users) {

        $rootScope.app = appProperties;

        AppPropertiesService.getAppProperties().then(function (response) {
            $rootScope.modes = response.data.appPropertiesModes;
            $rootScope.links = response.data.appPropertiesLinks;
            $rootScope.registration = response.data.appPropertiesRegistration;
        });

        $rootScope.userVerficationPerformed = false;

        $rootScope.inceptionYear = '2012';
        $rootScope.currentYear = new Date().getFullYear();
        users.getUser().then(function (user) {
            $rootScope.user = user;
            $rootScope.userVerficationPerformed = true;
        });
    }

    function eurekaConfig($stateProvider, $urlRouterProvider, $httpProvider) {

        if (!$httpProvider.defaults.headers.get) {
            $httpProvider.defaults.headers.get = {};
        }
        $httpProvider.defaults.headers.get['If-Modified-Since'] = 'Mon, 26 Jul 1997 05:00:00 GMT';
        $httpProvider.defaults.headers.get['Cache-Control'] = 'no-cache, no-store, must-revalidate';
        $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';

        $urlRouterProvider.otherwise('/index');

        $stateProvider.state('index', {
            url: '/index',
            templateUrl: 'eureka/views/main/main.html'
        });
    }
})();
'use strict';

(function () {
  'use strict';

  /**
   * @ngdoc overview
   * @name eureka.cohorts
   * @description
   * The module for the cohorts section of the Eureka application.
   */
  angular.module('eureka.cohorts', []);

  angular.module('eureka.cohorts').config(cohortsConfig);

  cohortsConfig.$inject = ['$stateProvider'];

  function cohortsConfig($stateProvider) {

    $stateProvider.state('cohorts', {
      url: '/cohorts',
      templateUrl: 'eureka/cohorts/views/main/main.html',
      controller: 'cohorts.MainCtrl',
      controllerAs: 'cohorts'
    }).state('testCohorts', {
      url: '/test/cohorts',
      templateUrl: 'eureka/cohorts/views/test/test.html',
      controller: 'cohorts.TestCtrl',
      controllerAs: 'cohorts'
    }).state('newCohort', {
      url: '/cohorts/new',
      templateUrl: 'eureka/cohorts/views/new/new.html',
      controller: 'cohorts.NewCtrl',
      controllerAs: 'newCohort'
    }).state('editCohort', {
      url: '/cohorts/:key',
      templateUrl: 'eureka/cohorts/views/edit/edit.html',
      controller: 'cohorts.EditCtrl',
      controllerAs: 'editCohort'
    });
  }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc overview
     * @name eureka.cohorts
     * @description
     * The module for the cohorts section of the Eureka application.
     */
    angular.module('eureka.help', []);

    angular.module('eureka.help').config(helpConfig);

    helpConfig.$inject = ['$stateProvider'];

    function helpConfig($stateProvider) {

        $stateProvider.state('help', {
            url: '/help',
            templateUrl: 'eureka/help/views/main/main.html'
        });
    }
})();
'use strict';

(function () {
  'use strict';

  /**
   * @ngdoc overview
   * @name eureka.jobs
   * @description
   * The module for the jobs section of the Eureka application.
   */
  angular.module('eureka.jobs', []);

  angular.module('eureka.cohorts').config(jobsConfig);

  jobsConfig.$inject = ['$stateProvider'];

  function jobsConfig($stateProvider) {

    $stateProvider.state('jobs', {
      url: '/jobs',
      templateUrl: 'eureka/jobs/views/main/main.html',
      controller: 'jobs.MainCtrl',
      controllerAs: 'jobs'
    });
  }
})();
'use strict';

(function () {
  'use strict';

  /**
   * @ngdoc overview
   * @name eureka.phenotypes
   * @description
   * The module for the phenotypes section of the Eureka application.
   */
  angular.module('eureka.phenotypes', ['ui.router']);

  angular.module('eureka.phenotypes').config(phenotypesConfig);

  phenotypesConfig.$inject = ['$stateProvider'];

  function phenotypesConfig($stateProvider) {

    $stateProvider.state('phenotypes', {
      url: '/phenotypes',
      templateUrl: 'eureka/phenotypes/views/main/main.html',
      controller: 'phenotypes.MainCtrl',
      controllerAs: 'phenotypes'
    }).state('editPhenotype', {
      url: '/phenotypes/edit/:id',
      templateUrl: 'eureka/phenotypes/views/edit/edit.html',
      controller: 'phenotypes.EditCtrl',
      controllerAs: 'editPhenotype'
    }).state('createPhenotype', {
      url: '/phenotypes/:type',
      templateUrl: 'eureka/phenotypes/views/create/create.html',
      controller: 'phenotypes.CreateCtrl',
      controllerAs: 'createPhenotype'
    });
  }
})();
'use strict';angular.module('eureka').run(['$templateCache',function($templateCache){$templateCache.put('eureka/directives/cohort-members-drop-zone/cohort-members-drop-zone.html','<!-- angular-ui-tree drop zone -->\n<md-whiteframe flex class="md-whiteframe-z2" layout="column" layout-align="start start" style="margin-top: 30px;">\n    <div layout-fill ui-tree="dropZone.treeOptions" data-empty-placeholder-enabled="false">\n        <ol ui-tree-nodes="" ng-model="dropZone.memberList" class="member-tree-list">\n            <li ui-tree-node data-nodrag layout-fill class="text-center" style="padding: 30px 20px;"\n                ng-if="!dropZone.memberList.length">\n                <h3 class="md-title">Drag Members Here</h3>\n            </li>\n            <li class="md-subhead" ng-repeat="item in dropZone.memberList" ui-tree-node data-nodrag layout-fill>\n                <i class="fa fa-times" ng-click="remove(this)"></i> {{item.displayName}}\n            </li>\n        </ol>\n    </div>\n</md-whiteframe>\n<!-- end of angular-ui-tree drop zone -->\n');$templateCache.put('eureka/directives/cohort-members-tree/cohort-members-tree.html','<md-card>\n    <md-tabs md-dynamic-height md-border-bottom>\n        <md-tab label="System">\n            <md-content class="md-padding">\n                <md-input-container md-no-float>\n                    <input flex ng-model="tree.treeSearch" placeholder="Search" ng-model-options=\'{ debounce: 1000 }\' ng-change="tree.filterCohortList()">\n                </md-input-container>\n                <md-progress-circular class="md-hue-1" md-mode="indeterminate" ng-if="tree.loading"></md-progress-circular>\n                <div ui-tree data-empty-placeholder-enabled="false" data-drag-enabled="true" data-drag-delay="200" data-clone-enabled="true">\n                    <ol ui-tree-nodes="" data-nodrop-enabled="true" ng-model="tree.treeData" id="tree-root">\n                        <li ng-repeat="node in tree.treeData" ui-tree-node ng-include="\'nodes_renderer.html\'" collapsed="true"></li>\n                    </ol>\n                </div>\n                <!-- Nested node template -->\n                <script type="text/ng-template" id="nodes_renderer.html">\n                    <div class="md-subhead" ng-class="{\'node-disabled\': !tree.nodeAllowed(node)}" style="padding-bottom: 3px;" ui-tree-handle ng-click="toggle(this); tree.toggleNode(node)">\n                        <i class="fa" ng-if="node.children" style="cursor: pointer; margin-right: 5px;" ng-class="{\n                                \'fa-plus-square\': collapsed,\n                                \'fa-minus-square\': !collapsed\n                            }"></i>\n                        <i class="fa fa-file-o" style="margin-right: 5px;" ng-if="!node.children"></i>\n                        {{node.displayName}}\n                    </div>\n                    <md-progress-linear class="md-hue-1" style="margin:5px 0;" md-mode="indeterminate" ng-if="node.loading"></md-progress-linear>\n                    <ol ui-tree-nodes="" data-nodrop-enabled="true" ng-class="{ \'hidden\': collapsed }" ng-model="node.nodes">\n                        <li ng-repeat="node in node.nodes" ui-tree-node ng-include="\'nodes_renderer.html\'" collapsed="true">\n                        </li>\n                    </ol>\n                </script>\n            </md-content>\n        </md-tab>\n        <md-tab label="User">\n            <md-content class="md-padding">\n            </md-content>\n        </md-tab>\n    </md-tabs>\n</md-card>\n');$templateCache.put('eureka/directives/global-grid/global-grid.html','<div class="grid" ui-grid="gridOptions"></div> ');$templateCache.put('eureka/directives/table-directive-one/table-directive-one.html','             <table ng-table="tableParameters" class="table" show-filter="true">\n                    <tr ng-repeat="user in tableData">\n                        <td>\n                            <a href="#" title="Edit">\n                                <span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>\n                            </a>\n                            <span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>\n                        </td>\n                        <td title="\'Name\'" filter="{ name: \'text\'}" sortable="\'name\'">\n                            {{user.name}}\n                        </td>\n                        <td title="\'Description\'" filter="{ description: \'text\'}" sortable="\'description\'">\n                            {{user.description}}\n                        </td>\n                        <td title="\'Type\'" filter="{ type: \'text\'}" sortable="\'type\'">\n                            {{user.type}}\n                        </td>\n                        <td title="\'Created\'" filter="{ created_at: \'text\'}" sortable="\'created_at\'">\n                            {{user.created_at | date:\'MM/dd/yyyy\'}}\n                        </td>\n                    </tr>\n                </table>  ');$templateCache.put('eureka/views/main/main.html','<div class="jumbotron">\n    <img id="logo" class="img-responsive" src="assets/images/logo.png"/>\n    <p class="vert-offset text-center">\n        Clinical data ETL and phenotyping system\n    </p>\n</div>\n<div id="indexPanels">\n    <div class="container-fluid">\n        <div class="row" ng-if="modes.demoMode">\n            <div class="alert alert-warning">NOTE: This demonstration web site is NOT suitable for\n                use with sensitive data including patient data that contains\n                identifiers.\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">Getting Started</div>\n                    \n                        <div class="panel-body text-center" ng-show="userVerficationPerformed == false ">\n                            <div class="container-fluid">\n                                <div class="row">\n                                    <div class="col-xs-12">\n                                        <h4><i class="fa fa-refresh fa-spin fa-2x"></i>\n                                        </h4>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n\n                        <div class="panel-body text-center" ng-show="userVerficationPerformed == true && !user">\n                            <div class="container-fluid">\n                                <div class="row" ng-switch="registration.registrationEnabled">\n                                    <div ng-switch-when="true">\n                                        <div class="col-xs-6">\n                                            <h4>Learn about Eureka!</h4>\n                                            <a ng-href="{{links.aiwUrl}}/#overview" target="_blank"\n                                               class="btn btn-primary btn-lg">\n                                                About Eureka!\n                                            </a>\n                                        </div>\n                                        <div class="col-xs-6">\n                                            <h4>Get an account</h4>\n                                            <a href="{{links.userWebappUrl}}/chooseaccounttype" target="_blank"\n                                               class="btn btn-primary btn-lg">\n                                                Register\n                                            </a>                                          \n                                        </div>\n                                    </div>\n                                    <div ng-switch-default>\n                                        <div class="col-xs-12">\n                                            <h4>Learn about Eureka!</h4>\n                                            <a ng-href="{{links.aiwUrl}}/#overview" target="_blank"\n                                               class="btn btn-primary btn-lg">\n                                                About Eureka!\n                                            </a>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>        \n                    \n                        <div class="panel-body text-center" ng-show="userVerficationPerformed == true && user">\n                            <div class="container-fluid">\n                                <div class="row">\n                                    <div class="col-xs-12">\n                                        <h4>Learn more about Eureka!</h4>\n                                        <a ng-href="{{links.aiwUrl}}/#overview" target="_blank"\n                                           class="btn btn-primary btn-lg">\n                                            About Eureka!\n                                        </a>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    \n                </div>               \n            </div>\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">Want to evaluate Eureka! at your institution?</div>\n                    <div class="panel-body text-center">\n                        <div class="container-fluid">\n                            <div class="row">\n                                <div class="col-xs-12">\n                                    <h4>Contact us for options</h4>\n                                    <a ng-href="{{links.aiwUrl}}/contact/" target="_blank"\n                                       class="btn btn-primary btn-lg">\n                                        Contact Us\n                                    </a>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="row" ng-controller="NewsAndFundingController">\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">News</div>\n                    <div class="panel-body" id="versionHistory">\n                        \n                        <div class="row" ng-repeat-start="versionItem in versionHistory" ng-if="$first">\n                            <div class="col-sm-2" >{{versionItem.releaseDate}}</div>\n                            <div class="col-sm-10">{{versionItem.description}}</div>\n                        </div>\n                        <!--add offset style from 2nd items to keep the css style as original design-->\n                        <div class="row vert-offset" ng-repeat-end ng-if="!$first">\n                            <div class="col-sm-2" >{{versionItem.releaseDate}}</div>\n                            <div class="col-sm-10">{{versionItem.description}}</div>                            \n                        </div>\n                        \n                    </div>\n                </div>\n            </div>\n            <div class="col-md-6">\n                <div class="panel panel-info">\n                    <div class="panel-heading">Funding</div>\n                    <div class="panel-body text-center">\n                        <p>The software powering this site has been supported in part by \n                            <span ng-bind-html="supportedByHTML" id="supportBy"></span>\n                        </p>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n');$templateCache.put('eureka/cohorts/views/edit/edit.html','<div class="row">\n  <div class="col-sm-12">\n    <h3>Cohort Editor</h3>\n  </div>\n</div>\n\n<div class="row">\n    <div class="col-md-12">\n        <div id="definitionContainer" class="col-md-8">\n            <form id="categorizationForm" class="vert-offset" role="form">\n                <div class="form-group">\n                    <label for="patCohortDefName" class="control-label">Name</label>\n                    <input type="text" id="patCohortDefName" class="form-control" ng-model="editCohort.destination.name" />\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDescription" class="control-label">Description</label>\n                    <textarea id="patCohortDescription" class="form-control" ng-model="editCohort.destination.description"></textarea>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="form-group">\n\t\t\t\t\t\t<label for="patCohortDefinition" class="control-label">Members</label>\n\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class="form-group text-center vert-offset">\n\t\t\t\t\t\t<button id="savePhenotypeButton" type="button" class="btn btn-primary">Save</button>\n\t\t\t\t\t</div>\n\t\t\t\t</form>\n\t\t\t</div>\n  </div>\n</div>\n\n<!--<h3>Cohort Editor</h3>-->\n<!--<p>-->\n    <!--Select the system and user-defined elements from the ontology that will define the patient cohort.-->\n<!--</p>-->\n<!--<div layout="column" layout-gt-md="row" >  -->\n    <!--<div class="col-xs-4">-->\n        <!--<ul class="nav nav-tabs">-->\n            <!--<li class = "active">-->\n                <!--<a href = "#systemElems" data-toggle="tab">System</a>-->\n            <!--</li>-->\n            <!--<li>-->\n                <!--<a href="#userElems" data-toggle="tab">User</a>-->\n            <!--</li>-->\n        <!--</ul>-->\n        <!--<div id="treeContent" class="tab-content proposition-tree">-->\n            <!--<div id="systemElems" class="tab-pane fade active in">-->\n                <!--<jstree-->\n                        <!--tree-url="protected/systemlist"-->\n                        <!--tree-search="protected/jstree3_searchsystemlist"-->\n                        <!--search-update-div="#searchUpdateDiv"-->\n                        <!--search-validation-modal="#searchValidationModal"-->\n                        <!--search-no-results-modal="#searchNoResultsModal"-->\n                        <!--tree-css-url="assets/css/jstree-themes/default/style.css"-->\n                        <!--/>-->\n                <!--<div id="searchUpdateDiv" class="searchUpdateMessage"></div>-->\n            <!--</div>-->\n            <!--<div id="userElems" class="tab-pane fade">-->\n                <!--<div id="userTree"></div>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--\n    <md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n        <cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n    </md-content> -->\n\n    <!--<div id="definitionContainer" class="col-xs-8">-->\n        <!--<form id="categorizationForm" class="vert-offset" role="form">-->\n            <!--<div class="form-group">-->\n                <!--<label for="patCohortDefName" class="control-label">Name</label>-->\n                <!--<input type="text" id="patCohortDefName" ng-model="editCohort.cohortDestination.name"-->\n                       <!--class="form-control"/>-->\n            <!--</div>-->\n            <!--<div class="form-group">-->\n                <!--<label for="patCohortDescription" class="control-label">Description</label>-->\n                <!--<textarea id="patCohortDescription" class="form-control" ng-model="editCohort.cohortDestination.description"></textarea>-->\n            <!--</div>-->\n            <!--<div class="form-group">-->\n                <!--<label for="patCohortDefinition" class="control-label">Members</label>-->\n                <!--<div id="patCohortDefinition"-->\n                     <!--class="jstree-drop tree-drop tree-drop-multiple"-->\n                     <!--title="Drop the system and/or user-defined data element members that define your patient cohort in here">-->\n\n                    <!--<ul class="sortable"-->\n                        <!--data-drop-type="multiple"-->\n                        <!--data-proptype="empty"-->\n                        <!--ng-repeat="phenotype in editCohort.cohortDestination.phenotypes"-->\n                        <!--phenotype-editor="phenotype"-->\n                            <!--/>-->\n\n                <!--</div>-->\n            <!--</div>-->\n            <!--<div class="form-group text-center vert-offset">-->\n                <!--<button id="savePropositionButton" type="button" class="btn btn-primary">Save</button>-->\n            <!--</div>-->\n        <!--</form>-->\n    <!--</div>-->\n<!--\n    <md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n        <md-card>\n            <md-card-content>\n                <h2 class="md-headline" style="margin-top: 0">Edit Cohort</h2>\n                <p>\n                    Select the system and user-defined elements from the ontology that will define the patient cohort.\n                </p>\n                <form name="userForm">\n                    <md-input-container flex>\n                        <label>Name</label>\n                        <input ng-model="newCohort.cohort.name">\n                    </md-input-container>\n                    <md-input-container flex>\n                        <label>Description</label>\n                        <textarea ng-model="newCohort.cohort.description" columns="1" md-maxlength="250"></textarea>\n                    </md-input-container>\n\n                    <cohort-members-drop-zone member-list="newCohort.memberList"></cohort-members-drop-zone>\n\n                </form>\n            </md-card-content>\n            <div class="md-actions md-padding" layout="row" layout-align="start center">\n                <md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n            </div>\n        </md-card>\n    </md-content>\n\n</div>\n<div id="deleteModal" class="modal fade" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="deleteModalLabel" class="modal-title">Delete Element</h4>\n            </div>\n            <div id="deleteContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button id="deleteButton" type="button" class="btn btn-primary">Delete</button>\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="replaceModal" class="modal fade" role="dialog" aria-labelledby="replaceModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="replaceModalLabel" class="modal-title">Replace Element</h4>\n            </div>\n            <div id="replaceContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button id="replaceButton" type="button" class="btn btn-primary">Replace</button>\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="errorModal" class="modal fade" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="errorModalLabel" class="modal-title">Error</h4>\n            </div>\n            <div id="errorContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="searchModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="searchModalLabel" class="modal-title">\n                    Broad Search Update\n                </h4>\n            </div>\n            <div id="searchContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="searchValidationModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="searchModalLabel" class="modal-title">\n                    Search String Validation Failed\n                </h4>\n            </div>\n            <div id="searchContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>\n<div id="searchNoResultsModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">\n    <div class="modal-dialog modal-lg">\n        <div class="modal-content">\n            <div class="modal-header">\n                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>\n                <h4 id="searchModalLabel" class="modal-title">\n                    No Search Results\n                </h4>\n            </div>\n            <div id="searchContent" class="modal-body">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>\n            </div>\n        </div>\n    </div>\n</div>  -->\n\n');$templateCache.put('eureka/cohorts/views/main/main.html','<style>\n.myGrid {\n    width: 800px;\n    height: 250px;\n  }\n</style>\n\n<div class="row">\n    <div class="col-sm-12">\n        <h3>Cohorts</h3>\n        <p>Define a cohort to identify the patient population in your datasets.\n        </p>\n        <p>\n            <a ui-sref="newCohort" class="btn btn-primary"><span class="glyphicon glyphicon-plus-sign"></span>\n            Define New Cohort\n\t\t\t</a>\n        </p>\n        <!-- removing ui-grid for now -->\n        <!-- <div ui-grid="cohorts.gridOptions" ui-grid-pagination ui-grid-edit class="grid"></div> -->\n    </div>\n</div>\n<!-- ng-table -->\n<div class="row">\n    <div class="col-md-12">\n        <table ng-table="cohorts.tableParams" class="table" show-filter="true">\n            <tr ng-repeat="user in $data">\n                <td>\n                    <a ui-sref="editCohort({key: user.name})" title="Edit">\n                        <span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>\n                    </a>\n                    <span class="glyphicon glyphicon-remove delete-icon" title="Delete" ng-click="cohorts.deleteCohort(user.name, $index)"></span>\n                </td>\n                <td title="\'Name\'" filter="{ name: \'text\'}" sortable="\'name\'">\n                    {{user.name}}\n                </td>\n                <td title="\'Description\'" filter="{ description: \'text\'}" sortable="\'description\'">\n                    {{user.description}}\n                </td>\n                <td title="\'Type\'" filter="{ type: \'text\'}" sortable="\'type\'">\n                    {{user.type}}\n                </td>\n                <td title="\'Created\'" filter="{ created_at: \'text\'}" sortable="\'created_at\'">\n                    {{user.created_at | date:\'MM/dd/yyyy\'}}\n                </td>\n            </tr>\n        </table>\n    </div>\n</div>\n    <script type="text/ng-template" id="myModal.html">\n        <div class="modal-header">\n            <h3 class="modal-title">Delete Element</h3>\n        </div>\n        <div class="modal-body">\n            Are you sure you would like to remove this item?\n        </div>\n        <div class="modal-footer">\n            <button class="btn btn-primary" ng-click="mo.ok()">Delete</button>\n            <button class="btn btn-primary" ng-click="mo.cancel()">Close</button>\n        </div>\n    </script>\n\n    <script type="text/ng-template" id="errorModal.html">\n    <div class="modal-header">\n        <h3 class="modal-title">Error</h3>\n    </div>\n    <div class="modal-body">\n       {{mod.data}}\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-primary" ng-click="mod.cancel()">Close</button>\n    </div>\n</script>\n\n\n<!--\n<div layout>\n    <md-content flex layout-padding>\n        <md-card>  -->\n        <!--<h3>Cohorts</h3>-->\n\n        <!--<p>Define a cohort to identify the patient population in your datasets.-->\n        <!--</p>-->\n        <!--<a ui-sref="newCohort" class="btn btn-primary"><span-->\n                <!--class="glyphicon glyphicon-plus-sign"></span>Define New Cohort-->\n        <!--</a>-->\n        <!--<table class="table table-responsive vert-offset">-->\n            <!--<tr>-->\n                <!--<th>Action</th>-->\n                <!--<th>Name</th>-->\n                <!--<th>Description</th>-->\n                <!--<th>Created Date</th>-->\n                <!--<th>Last Modified</th>-->\n            <!--</tr>-->\n            <!--<tr ng-repeat="cohortDestination in cohorts.list">-->\n                <!--<td>-->\n                    <!--<a ui-sref="editCohort({key: cohortDestination.name})" title="Edit">-->\n                        <!--<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>-->\n                    <!--</a>-->\n                    <!--<span class="glyphicon glyphicon-remove delete-icon" title="Delete" ng-click="remove(cohortDestination.name)"></span>-->\n                <!--</td>-->\n                <!--<td>{{ cohortDestination.name }}</td>-->\n                <!--<td>{{ cohortDestination.description }}</td>-->\n                <!--<td>{{ cohortDestination.created_at | date : shortDate }}</td>-->\n                <!--<td>{{ cohortDestination.updated_at | date : shortDate }}</td>-->\n            <!--</tr>-->\n        <!--</table>-->\n\n        <!-- begin md-data-table \n        <md-data-table-toolbar ng-hide="cohorts.selected.length || cohorts.filter.show">\n            <h2 class="md-title">Cohortsxx</h2>\n            <div flex></div>\n            <md-button class="md-icon-button" ng-click="cohorts.filter.show = true">\n                <i class="material-icons md-dark">search</i>\n            </md-button>\n            <md-button class="md-icon-button" ui-sref="newCohort">\n                <i class="material-icons md-dark">add_circle</i>\n            </md-button>\n        </md-data-table-toolbar>\n\n        <md-data-table-toolbar ng-show="cohorts.filter.show && !cohorts.selected.length">\n            <i class="material-icons md-dark">search</i>\n            <form flex name="cohorts.filter.form">\n                <input type="text" ng-model="cohorts.query.filter" ng-model-options="cohorts.filter.options" placeholder="Search...">\n            </form>\n            <md-button class="md-icon-button" ng-click="cohorts.removeFilter()">\n                <i class="material-icons md-dark">close</i>\n            </md-button>\n        </md-data-table-toolbar>\n\n        <md-data-table-toolbar class="alternate" ng-show="cohorts.selected.length" layout-align="space-between">\n            <div>{{cohorts.selected.length}} {{cohorts.selected.length > 1 ? \'items\' : \'item\'}} selected</div>\n            <div flex></div>\n            <md-button class="md-icon-button" ng-show="cohorts.selected.length == 1" ui-sref="editCohort({ key: cohorts.selected[0].key })">\n                <i class="material-icons md-dark">edit</i>\n            </md-button>\n            <md-button class="md-icon-button">\n                <i class="material-icons md-dark">delete</i>\n            </md-button>\n        </md-data-table-toolbar>\n\n        <md-data-table-container>\n            <table md-data-table md-row-select="cohorts.selected" md-progress="cohorts.deferred">\n                <thead md-order="cohorts.query.order" md-trigger="cohorts.onOrderChange">\n                    <tr>\n                        <th name="Name" order-by="name"></th>\n                        <th name="Description" order-by="description"></th>\n                        <th name="Created" unit="date" order-by="created_at"></th>\n                        <th name="Last Modified" unit="date" order-by="updated_at"></th>\n                    </tr>\n                </thead>\n                <tbody>\n                    <tr md-auto-select ng-repeat="cohort in cohorts.cohortsList">\n                        <td>{{cohort.name}}</td>\n                        <td>{{cohort.description}}</td>\n                        <td>{{cohort.created_at | date:\'shortDate\'}}</td>\n                        <td>{{cohort.updated_at | date:\'shortDate\'}}</td>\n                    </tr>\n                </tbody>\n            </table>\n        </md-data-table-container>\n\n        <md-data-table-pagination md-limit="cohorts.query.limit" md-page="cohorts.query.page" md-total="{{cohorts.cohortsList.length}}" md-trigger="cohorts.onPaginationChange"></md-data-table-pagination>\n        end md-data-table \n\n        </md-card>\n    </md-content>  -->\n</div>');$templateCache.put('eureka/cohorts/views/new/new.html','<div class="row">\n  <div class="col-sm-12">\n    <h3> New Cohort Editor</h3>\n  </div>\n</div>\n\n<div class="row">\n  <div class="col-md-12">\n  </div>\n</div>\n<div class="row">\n    <div class="col-md-12">\n        <div id="definitionContainer" class="col-md-8">\n            <form id="categorizationForm" class="vert-offset" role="form">\n                <div class="form-group">\n                    <label for="patCohortDefName" class="control-label">Name</label>\n                    <input type="text" id="patCohortDefName" class="form-control" />\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDescription" class="control-label">Description</label>\n                    <textarea id="patCohortDescription" class="form-control"></textarea>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="form-group">\n\t\t\t\t\t\t<label for="patCohortDefinition" class="control-label">Members</label>\n\n\t\t\t\t\t</div>\n\n\t\t\t\t\t<div class="form-group text-center vert-offset">\n\t\t\t\t\t\t<button id="savePhenotypeButton" type="button" class="btn btn-primary">Save</button>\n\t\t\t\t\t</div>\n\t\t\t\t</form>\n\t\t\t</div>\n  </div>\n</div>\n\n<!--<h3>Cohort Editor</h3>-->\n<!--<p>-->\n    <!--Select the system and user-defined elements from the ontology that will define the patient cohort.-->\n<!--</p>-->\n\n    <!--<div class="col-xs-4">-->\n\n        <!--<ul class="nav nav-tabs">-->\n            <!--<li ng-class="{active: newCohort.activeTab == 1}">-->\n                <!--&lt;!&ndash;<a href = "#systemElems" data-toggle="tab">System</a>&ndash;&gt;-->\n                <!--<a href ng-click="newCohort.activeTab = 1" >System</a>-->\n            <!--</li>-->\n            <!--<li ng-class="{active: newCohort.activeTab == 2}">-->\n                <!--<a href ng-click="newCohort.activeTab = 2" >User</a>-->\n            <!--</li>-->\n        <!--</ul>-->\n        <!--<div id="treeContent" ng-init="newCohort.activeTab = 1" class="tab-content proposition-tree">-->\n            <!--&lt;!&ndash;<div id="systemElems" class="tab-pane fade active in" ng-show="tab.isSet(1)">&ndash;&gt;-->\n            <!--<div id="systemElems" ng-show="newCohort.activeTab == 1">-->\n                <!--<jstree-->\n                        <!--tree-url="/eureka-webapp/protected/systemlist"-->\n                        <!--tree-search="/eureka-webapp/protected/jstree3_searchsystemlist"-->\n                        <!--search-update-div="#searchUpdateDiv"-->\n                        <!--search-validation-modal="#searchValidationModal"-->\n                        <!--search-no-results-modal="#searchNoResultsModal"-->\n                        <!--tree-css-url="assets/css/jstree-themes/default/style.css"-->\n                        <!--/>-->\n                <!--<div id="searchUpdateDiv" class="searchUpdateMessage"></div>-->\n            <!--</div>-->\n            <!--&lt;!&ndash;<div id="userElems" class="tab-pane fade" ng-show="tab.isSet(2)">&ndash;&gt;-->\n            <!--<div id="userElems" ng-show="newCohort.activeTab == 2">-->\n                <!--<div id="userTree"></div>-->\n            <!--</div>-->\n        <!--</div>-->\n\n\n    <!--</div>-->\n    <!--<div id="definitionContainer" class="col-xs-8">-->\n        <!--<form id="categorizationForm" class="vert-offset" role="form">-->\n            <!--<div class="form-group">-->\n                <!--<label for="patCohortDefName" class="control-label">Name</label>-->\n                <!--<input type="text" id="patCohortDefName" ng-model="newCohort.cohortDestination.name"-->\n                       <!--class="form-control"/>-->\n            <!--</div>-->\n            <!--<div class="form-group">-->\n                <!--<label for="patCohortDescription" class="control-label">Description</label>-->\n                <!--<textarea id="patCohortDescription" class="form-control" ng-model="newCohort.cohortDestination.description"></textarea>-->\n            <!--</div>-->\n            <!--<div class="form-group">-->\n                <!--<label for="patCohortDefinition" class="control-label">Members</label>-->\n                <!--<div id="patCohortDefinition"-->\n                     <!--class="jstree-drop tree-drop tree-drop-multiple"-->\n                     <!--title="Drop the system and/or user-defined data element members that define your patient cohort in here">-->\n                    <!--<ul class="sortable" data-drop-type="multiple" data-proptype="empty">-->\n                    <!--</ul>-->\n                <!--</div>-->\n            <!--</div>-->\n            <!--<div class="form-group text-center vert-offset">-->\n                <!--<button id="savePropositionButton" type="button" class="btn btn-primary">Save</button>-->\n            <!--</div>-->\n        <!--</form>-->\n    <!--</div>-->\n    <!-- begin angular-ui-tree -->\n<!--\n    <md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n        <cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n    </md-content>  -->\n    <!--end angular-ui-tree  -->\n<!--\n    <md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n        <md-card>\n            <md-card-content>\n                <h2 class="md-headline" style="margin-top: 0">New Cohort</h2>\n                <p>\n                    Select the system and user-defined elements from the ontology that will define the patient cohort.\n                </p>\n                <form name="userForm">\n                    <md-input-container flex>\n                        <label>Name</label>\n                        <input ng-model="newCohort.cohort.name">\n                    </md-input-container>\n                    <md-input-container flex>\n                        <label>Description</label>\n                        <textarea ng-model="newCohort.cohort.description" columns="1" md-maxlength="250"></textarea>\n                    </md-input-container>\n\n                    <cohort-members-drop-zone member-list="newCohort.memberList"></cohort-members-drop-zone>\n\n                </form>\n            </md-card-content>\n            <div class="md-actions md-padding" layout="row" layout-align="start center">\n                <md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n            </div>\n        </md-card>\n    </md-content>\n\n</div>  -->\n<!--<div id="deleteModal" class="modal fade" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">-->\n    <!--<div class="modal-dialog modal-lg">-->\n        <!--<div class="modal-content">-->\n            <!--<div class="modal-header">-->\n                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n                <!--<h4 id="deleteModalLabel" class="modal-title">Delete Element</h4>-->\n            <!--</div>-->\n            <!--<div id="deleteContent" class="modal-body">-->\n            <!--</div>-->\n            <!--<div class="modal-footer">-->\n                <!--<button id="deleteButton" type="button" class="btn btn-primary">Delete</button>-->\n                <!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--</div>-->\n<!--<div id="replaceModal" class="modal fade" role="dialog" aria-labelledby="replaceModalLabel" aria-hidden="true">-->\n    <!--<div class="modal-dialog modal-lg">-->\n        <!--<div class="modal-content">-->\n            <!--<div class="modal-header">-->\n                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n                <!--<h4 id="replaceModalLabel" class="modal-title">Replace Element</h4>-->\n            <!--</div>-->\n            <!--<div id="replaceContent" class="modal-body">-->\n            <!--</div>-->\n            <!--<div class="modal-footer">-->\n                <!--<button id="replaceButton" type="button" class="btn btn-primary">Replace</button>-->\n                <!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--</div>-->\n<!--<div id="errorModal" class="modal fade" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">-->\n    <!--<div class="modal-dialog modal-lg">-->\n        <!--<div class="modal-content">-->\n            <!--<div class="modal-header">-->\n                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n                <!--<h4 id="errorModalLabel" class="modal-title">Error</h4>-->\n            <!--</div>-->\n            <!--<div id="errorContent" class="modal-body">-->\n            <!--</div>-->\n            <!--<div class="modal-footer">-->\n                <!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--</div>-->\n<!--<div id="searchModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">-->\n    <!--<div class="modal-dialog modal-lg">-->\n        <!--<div class="modal-content">-->\n            <!--<div class="modal-header">-->\n                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n                <!--<h4 id="searchModalLabel" class="modal-title">-->\n                    <!--Broad Search Update-->\n                <!--</h4>-->\n            <!--</div>-->\n            <!--<div id="searchContent" class="modal-body">-->\n            <!--</div>-->\n            <!--<div class="modal-footer">-->\n                <!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--</div>-->\n<!--<div id="searchValidationModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">-->\n    <!--<div class="modal-dialog modal-lg">-->\n        <!--<div class="modal-content">-->\n            <!--<div class="modal-header">-->\n                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n                <!--<h4 id="searchModalLabel" class="modal-title">-->\n                    <!--Search String Validation Failed-->\n                <!--</h4>-->\n            <!--</div>-->\n            <!--<div id="searchContent" class="modal-body">-->\n            <!--</div>-->\n            <!--<div class="modal-footer">-->\n                <!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--</div>-->\n<!--<div id="searchNoResultsModal" class="modal fade" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">-->\n    <!--<div class="modal-dialog modal-lg">-->\n        <!--<div class="modal-content">-->\n            <!--<div class="modal-header">-->\n                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->\n                <!--<h4 id="searchModalLabel" class="modal-title">-->\n                    <!--No Search Results-->\n                <!--</h4>-->\n            <!--</div>-->\n            <!--<div id="searchContent" class="modal-body">-->\n            <!--</div>-->\n            <!--<div class="modal-footer">-->\n                <!--<button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>-->\n            <!--</div>-->\n        <!--</div>-->\n    <!--</div>-->\n<!--</div>-->\n\n<!--<script language="JavaScript">-->\n    <!--eureka.editor.setup(null,\'#userTree\', \'#definitionContainer\', \'#savePropositionButton\');-->\n<!--</script>-->\n\n');$templateCache.put('eureka/cohorts/views/test/test.html','<style>\n.myGrid {\n    width: 800px;\n    height: 250px;\n  }\n</style>\n\n\n<div class="row">\n    <div class="col-sm-12">\n        <h3>Cohorts</h3>\n        <p>Define a cohort to identify the patient population in your datasets.\n        </p>\n        <p>\n            <a href="editcohort" class="btn btn-primary"><span class="glyphicon glyphicon-plus-sign"></span>Define New Cohort\n\t\t\t\t</a>\n        </p>\n        <!-- ui-grid -->\n        <global-grid grid-options={{cohorts.columnDefs}} grid-data={{cohorts.testData}} class="grid"></global-grid>\n    </div>\n</div>\n<br><br><br>\n<!-- ng-table -->\n\n<!-- ng-table Directive  -->\n<table-directive-one table-data="cohorts.testData" table-parameters="cohorts.tableParams"></table-directive-one>\n\n</div>');$templateCache.put('eureka/help/views/main/main.html','<div class="help">\n                <h3>Help</h3>\n                <div class="row">\n                        <div class="col-sm-3">\n\t\t\t\t<span class="thumbnail text-center">\n\t\t\t\t\t<a ng-href="{{links.helpSiteUrl}}/get-started-guide/" class="imageAndCaption" target="eureka-help">\n\t\t\t\t\t\t<img alt="Getting Started" src="assets/images/100px-Help-getting-started.png"/>\n\t\t\t\t\t\t<span class="caption">\n\t\t\t\t\t\t\tGetting Started\n\t\t\t\t\t\t</span>\n                                        </a>\n\t\t\t\t</span>\n                        </div>\n                        <div class="col-sm-3">\n\t\t\t\t<span class="thumbnail text-center">\n\t\t\t\t\t<a ng-href="{{links.aiwUrl}}/faq/" class="imageAndCaption" target="eureka-help">\n\t\t\t\t\t\t<img alt="Frequently Asked Questions" src="assets/images/100px-Help-FAQ.png"/>\n\t\t\t\t\t\t<span class="caption">\n\t\t\t\t\t\t\tFrequently Asked Questions\n\t\t\t\t\t\t</span>\n                                        </a>\n\t\t\t\t</span>\n                        </div>\n                </div>\n                <p ng-if="modes.demoMode">\n                    NOTE: For privacy, data retention and other policies regarding this\n                    site, click on Frequently Asked Questions above.\n                </p>\n</div>\n');$templateCache.put('eureka/jobs/views/main/main.html','<div layout="column" layout-gt-md="row">\n\t<md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n\t<cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n\t</md-content>\n\t<md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n\t<form name="userForm">\n\t\t<md-card>\n\t\t<md-toolbar class="md-primary md-hue-1">\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Submit Job</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t</md-toolbar>\n\t\t<md-card-content>\n\t\t</md-card-content>\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Data</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t<md-card-content>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Spreadsheet</label>\n\t\t\t<md-select ng-model="createPhenotype.property.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t</md-card-content>\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Action</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t<md-card-content>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Load into</label>\n\t\t\t<md-select ng-model="createPhenotype.property.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<!--<label>Start</label>  -->\n\t\t\t<md-radio-group ng-model="data.group1">\n\t\t\t<md-radio-button value="replace" aria-label="Label 1">Replace Data</md-radio-button>\n\t\t\t<md-radio-button value="update"> Update Data </md-radio-button>\n\t\t\t</md-radio-group>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<div flow-init="{target: \'/upload\'}" flow-files-submitted="$flow.upload()" flow-file-success="$file.msg = $message">\n\t\t\t\t<input type="file" flow-btn/>\n\t\t\t\t<table>\n\t\t\t\t\t<tr ng-repeat="file in $flow.files">\n\t\t\t\t\t\t<td>{{$index+1}}</td>\n\t\t\t\t\t\t<td>{{file.name}}</td>\n\t\t\t\t\t\t<td>{{file.msg}}</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n\t\t\t</div>\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t</md-card-content>\n\t\t<md-toolbar class="md-primary md-hue-1">\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Concepts</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t</md-toolbar>\n\t\t<md-card-content>\n\t\t<cohort-members-drop-zone member-list="createPhenotype.memberList"></cohort-members-drop-zone>\n\t\t</md-card-content>\n\t\t<md-toolbar class="md-primary md-hue-1">\n\t\t<div class="md-toolbar-tools">\n\t\t\t<h3 class="md-title">\n\t\t\t<span>Date Range</span>\n\t\t\t</h3>\n\t\t</div>\n\t\t</md-toolbar>\n\t\t<md-card-content>\n\t\t<cohort-members-drop-zone member-list="createPhenotype.memberList"></cohort-members-drop-zone>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Start</label>\n\t\t\t<md-select ng-model="createPhenotype.property1.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t\t<md-input-container flex>\n\t\t\t<label>Has Earliest Date</label>\n\t\t\t<input type="number" step="any" name="propertyValue1" ng-model="createPhenotype.property1.value" />\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t<div layout layout-sm="column" layout-align="center center">\n\t\t\t<md-input-container flex>\n\t\t\t<label>Start</label>\n\t\t\t<md-select ng-model="createPhenotype.property1.name">\n\t\t\t<md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n\t\t\t{{unit}}\n\t\t\t</md-option>\n\t\t\t</md-select>\n\t\t\t</md-input-container>\n\t\t\t<md-input-container flex>\n\t\t\t<label>Has Latest Date</label>\n\t\t\t<input type="number" step="any" name="propertyValue1" ng-model="createPhenotype.property1.value" />\n\t\t\t</md-input-container>\n\t\t</div>\n\t\t</md-card-content>\n\t\t<div class="md-actions md-padding" layout="row" layout-align="start center">\n\t\t\t<md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n\t\t</div>\n\t\t</md-card>\n\t</form>\n\t</md-content>\n</div>');$templateCache.put('eureka/phenotypes/directives/phenotype-editor/phenotype-editor.html','<li\n    data-key="{{item.phenotypeKey}}"\n    data-desc="{{item.phenotypeDisplayName}}" data-type="{{item.type}}"\n    data-subtype="{{item.type == \'CATEGORIZATION\' ? item.categoricalType : \'\'}}">\n\n            <span class="glyphicon glyphicon-remove delete-icon"\n                  title="Remove this phenotype from the category"></span>\n\n    <span>{{item.phenotypeDisplayName}} ({{item.phenotypeKey}})</span>\n</li>');$templateCache.put('eureka/phenotypes/views/create/create.html','<style>\n    .ng-table-pager {\n        display: none;\n    }\n</style>\n<div class="row">\n    <div class="col-sm-12">\n        <h3>{{createPhenotype.type}} Editor</h3>\n        <p>\n            {{createPhenotype.description}}\n        </p>\n    </div>\n</div>\n\n<div class="row" ng-if="createPhenotype.type === \'Categorization\'">\n    <div class="col-md-12">\n        <div id="definitionContainer" class="col-md-8">\n            <form id="categorizationForm" class="vert-offset" role="form">\n                <div class="form-group">\n                    <label for="patCohortDefName" class="control-label">Name</label>\n                    <input type="text" id="patCohortDefName" class="form-control" />\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDescription" class="control-label">Description</label>\n                    <textarea id="patCohortDescription" class="form-control"></textarea>\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDefinition" class="control-label">Members</label>\n                    <div class="row">\n                        <div class="col-md-8">\n                            <div class="row">\n                                <ol class="breadcrumb">\n                                    <li class="breadcrumb-item" ng-repeat="x in createPhenotype.breadCrumbs"><a href ng-click="createPhenotype.setBreadCrumbs(x)">{{x.displayName}}</a></li>\n                                </ol>\n                            </div>\n                            <uib-tabset active="activeJustified" justified="true">\n                                <uib-tab index="0" heading="System">\n                                    <table ng-table="createPhenotype.tableParams" class="table" show-filter="true">\n                                        <tr ng-repeat="user in $data" class="animate">\n                                            <td>\n                                                <a title="Edit" ng-click="createPhenotype.selectNode(user) ">\n                                                    <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user.parent]" title=""></span>\n\n                                                </a>\n                                            </td>\n                                            <td title=" \'Name\' ">\n                                                {{user.displayName}}\n                                            </td>\n                                            <td>\n                                                <a title="Edit" ng-click="createPhenotype.addNode(user) ">\n                                                    <span class="glyphicon glyphicon-plus" title=""></span>\n\n                                                </a>\n                                            </td>\n\n                                        </tr>\n                                    </table>\n                                </uib-tab>\n                                <uib-tab index="1" heading="User">\n\n                                    <table ng-table="createPhenotype.tableParamsUser" class="table" show-filter="true">\n                                        <tr ng-repeat="user1 in $data" class="animate">\n                                            <td>\n                                                <a title="Edit" ng-click="createPhenotype.selectNode(user1) ">\n                                                    <span ng-class="{true: \'glyphicon glyphicon-folder-close\', false: \'glyphicon glyphicon-file\'}[user1.children]" title=""></span>\n\n                                                </a>\n                                            </td>\n                                            <td title=" \'Name\' ">\n                                                {{user1.text}}\n                                            </td>\n                                            <td>\n                                                <a title="Edit" ng-click="createPhenotype.addNode(user1) ">\n                                                    <span class="glyphicon glyphicon-plus" title=""></span>\n\n                                                </a>\n                                            </td>\n\n                                        </tr>\n                                    </table>\n                                </uib-tab>\n                            </uib-tabset>\n                        </div>\n                        <div class="col-md-4">\n\n                            <form>\n                                <fieldset>\n                                    <legend style="padding-top:61px;">Items Added&nbsp;</legend>\n                                    <p ng-repeat="selectedNode in createPhenotype.currentMemeberList">\n                                        <span>{{selectedNode.displayName}}</span>\n                                        <a title="remove" ng-click="createPhenotype.removeNode(selectedNode) ">\n                                            <span class="glyphicon glyphicon-remove" title="" style="color:red;"></span>\n\n                                        </a>\n                                        <p>\n                                </fieldset>\n                            </form>\n\n                        </div>\n                    </div>\n                </div>\n\n                <div class="form-group text-center vert-offset ">\n                    <button id="savePhenotypeButton " type="button " class="btn btn-primary ">Save</button>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n\n<div class="row " ng-if="createPhenotype.type===\'Frequency\' ">\n    <div class="col-md-12 ">\n        <div id="definitionContainer " class="col-md-8 ">\n            <form id="categorizationForm " class="vert-offset " role="form ">\n                <div class="form-group ">\n                    <label for="patCohortDefName " class="control-label ">Name</label>\n                    <input type="text " id="patCohortDefName " class="form-control " />\n                </div>\n                <div class="form-group ">\n                    <label for="patCohortDescription " class="control-label ">Description</label>\n                    <textarea id="patCohortDescription " class="form-control "></textarea>\n                </div>\n                <div class="form-group ">\n\n\n                </div>\n\n                <fieldset>\n                    <legend>Threshold</legend>\n                    <div class="form-group ">\n                        <div class="col-sm-4 ">\n                            <label class="sr-only " for="freqTypes ">Type</label>\n                            <select id="freqTypes " class="form-control " name="freqTypes " id="freqTypes " title="Specify whether only the first n intervals will be matched (First) or any n intervals (At least) "></select>\n                        </div>\n                        <div class="col-sm-4 ">\n                            <label class="sr-only " for="freqAtLeastField ">Count</label>\n                            <input type="number " id="frequencyCountField " name="freqAtLeastField " id="freqAtLeastField " min="1 " value=" " title="Specify the frequency count " class="form-control " />\n                        </div>\n                        <div class="col-sm-4 ">\n                            <label id="valueThresholdConsecutiveLabel " class="checkbox-inline ">\n\t\t\t\t\t\t<input type="checkbox " value="true " name="freqIsConsecutive "\n\t\t\t\t\t\t\t\t  title="For value threshold phenotypes, specifies whether no intervening values are present that do not match the threshold or any duration or property constraints specified below "\n\t\t\t\t\t\t\t   />consecutive\n\t\t\t\t\t</label>\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend><input class="checkbox-inline " type="checkbox " value="true " name="freqPhenotypeSpecifyDuration " /> Duration\n                    </legend>\n                    <div class="form-group ">\n                        <div class="col-md-2 ">\n                            <label class="sr-only " for="freqPhenotypeMinDurationValue ">From</label>\n                            <input type="text " class="form-control " name="freqPhenotypeMinDurationValue " id="freqPhenotypeMinDurationValue " placeholder="min " value=" " />\n                        </div>\n                        <div class="col-md-3 ">\n                            <label class="sr-only " for="freqPhenotypeMinDurationUnits ">From units</label>\n                            <select name="freqPhenotypeMinDurationUnits " id="freqPhenotypeMinDurationUnits " class="form-control ">\n                                                </select>\n                        </div>\n                        <div class="col-md-1 control-label " style="text-align: center ">\n                            <label for="freqPhenotypeMaxDurationValue ">to</label>\n                        </div>\n                        <div class="col-md-2 ">\n                            <input type="text " class="form-control " name="freqPhenotypeMaxDurationValue " placeholder="max " value=" " />\n                        </div>\n                        <div class="col-md-3 ">\n                            <label class="sr-only " for="freqPhenotypeMaxDurationUnits ">To units</label>\n                            <select name="freqPhenotypeMaxDurationUnits " id="freqPhenotypeMaxDurationUnits " class="form-control ">\n        \n                                                </select>\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend>\n                        <input type="checkbox " class="checkbox-inline propertyValueConstraint " name="freqPhenotypeSpecifyProperty "> Property value\n                    </legend>\n                    <div class="form-group ">\n                        <div class="col-sm-6 ">\n                            <label class="sr-only " for="freqPhenotypePropertyName ">Property name</label>\n                            <select name="freqPhenotypePropertyName " id="freqPhenotypePropertyName " class="form-control " data-properties-provider="freqMainPhenotype ">\n\t\t\t\t\t</select>\n                        </div>\n                        <div class="col-sm-6 ">\n                            <label class="sr-only " for="freqPhenotypePropertyValue ">Property value</label>\n                            <input type="text " class="form-control propertyValueField " name="freqPhenotypePropertyValue " id="freqPhenotypePropertyValue " value=" " />\n                        </div>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend>\n                        <input type="checkbox " value="true " name="freqIsWithin " class="checkbox-inline "> Distance between\n                    </legend>\n                    <div class="form-group ">\n                        <div class="col-md-2 ">\n                            <label class="sr-only " for="freqWithinAtLeast ">From</label>\n                            <input type="text " class="form-control " name="freqWithinAtLeast " id="freqWithinAtLeast " placeholder="min " value=" " />\n                        </div>\n                        <div class="col-md-3 ">\n                            <label class="sr-only " for="freqWithinAtLeastUnits ">Time units</label>\n                            <select name="freqWithinAtLeastUnits " id="freqWithinAtLeastUnits " class="form-control ">\n                                                </select>\n                        </div>\n                        <div class="col-md-1 control-label " style="text-align: center ">\n                            <label for="freqWithinAtMost ">to</label>\n                        </div>\n                        <div class="col-md-2 ">\n                            <input type="text " class="form-control " name="freqWithinAtMost " placeholder="max " id="freqWithinAtMost " value=" " />\n                        </div>\n                        <div class="col-md-3 ">\n                            <label class="sr-only " for="freqWithinAtMostUnits ">Time units</label>\n                            <select name="freqWithinAtMostUnits " class="form-control " id="freqWithinAtMostUnits ">\n                                                </select>\n                        </div>\n                    </div>\n                </fieldset>\n\n                <div class="form-group text-center vert-offset ">\n                    <button id="savePhenotypeButton " type="button " class="btn btn-primary ">Save</button>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n\n\n<!-- sequence  -->\n<div class="row " ng-if="createPhenotype.type===\'Sequence\' ">\n    <div class="col-md-12 ">\n        <div id="definitionContainer " class="col-md-8 ">\n            <form id="categorizationForm " class="vert-offset " role="form ">\n                <div class="form-group ">\n                    <label for="patCohortDefName " class="control-label ">Name</label>\n                    <input type="text " id="patCohortDefName " class="form-control " />\n                </div>\n                <div class="form-group ">\n                    <label for="patCohortDescription " class="control-label ">Description</label>\n                    <textarea id="patCohortDescription " class="form-control "></textarea>\n                </div>\n\n                <div class="form-group ">\n                    <div id="propDefinition " class="col-sm-12 panel panel-default ">\n                        <div class="row panel-heading ">\n                            <h4 class="panel-title ">Main Phenotype</h4>\n                        </div>\n                        <div class="form-group ">\n                            <div class="col-sm-12 ">\n                                <label class="sr-only " for="mainPhenotype ">Main phenotype</label>\n\n                            </div>\n                        </div>\n                        <fieldset>\n                            <legend><input id="mainPhenotypeSpecifyDuration " type="checkbox " value="true " class="checkbox-inline " name="mainPhenotypeSpecifyDuration " /> Duration\n                            </legend>\n                            <div class="form-group ">\n                                <div class="col-md-2 ">\n                                    <label class="sr-only " id="mainPhenotypeMinDurationValue ">From</label>\n                                    <input type="number " class="form-control " name="mainPhenotypeMinDurationValue " id="mainPhenotypeMinDurationValue " placeholder="min " value=" " />\n                                </div>\n                                <div class="col-md-3 ">\n                                    <label class="sr-only " id="mainPhenotypeMinDurationUnits ">From time units</label>\n                                    <select name="mainPhenotypeMinDurationUnits " id="mainPhenotypeMinDurationUnits " class="form-control "></select>\n                                </div>\n                                <div class="col-md-1 control-label " style="text-align: center ">\n                                    <label for="mainPhenotypeMaxDurationValue ">to</label>\n                                </div>\n                                <div class="col-md-2 ">\n                                    <input type="number " class="form-control " name="mainPhenotypeMaxDurationValue " id="mainPhenotypeMaxDurationValue " placeholder="max " value=" " />\n                                </div>\n                                <div class="col-md-3 ">\n                                    <label class="sr-only " id="mainPhenotypeMaxDurationUnits ">From time units</label>\n                                    <select name="mainPhenotypeMaxDurationUnits " id="mainPhenotypeMaxDurationUnits " class="form-control "> </select>\n                                </div>\n                            </div>\n                        </fieldset>\n                        <fieldset>\n                            <legend>\n                                <input type="checkbox " class="checkbox-inline propertyValueConstraint " value="true " name="mainPhenotypeSpecifyProperty " /> Property value\n                            </legend>\n                            <div class="form-group ">\n                                <div class="col-sm-6 ">\n                                    <label class="sr-only " for="mainPhenotypePropertyName ">Property name</label>\n                                    <select name="mainPhenotypePropertyName " class="form-control " id="mainPhenotypePropertyName " data-properties-provider="mainPhenotype ">  </select>\n                                </div>\n                                <div class="col-sm-6 ">\n                                    <label class="sr-only " for="mainPhenotypePropertyValue ">Property value</label>\n                                    <input type="text " class="form-control propertyValueField " name="mainPhenotypePropertyValue " id="mainPhenotypePropertyValue " value=" " />\n                                </div>\n                            </div>\n                        </fieldset>\n                    </div>\n                </div>\n\n                <div class="form-group ">\n                    <div id="sequenceRelatedPhenotypes " class="sequence-relations-container ">\n\n                        <div class="sequence-relation drop-parent panel panel-default col-sm-12 ">\n                            <div class="row panel-heading ">\n                                <h4 class="panel-title ">Related phenotype <span class="count ">1</span></h4>\n                            </div>\n                            <div class="form-group ">\n                                <div class="col-sm-12 ">\n                                    <label class="sr-only " for="relatedPhenotype${status.count} ">Related phenotype </label>\n\n                                </div>\n                            </div>\n                            <fieldset>\n                                <legend>\n                                    <input type="checkbox " value="true " name="sequenceRelPhenotypeSpecifyDuration " /> Duration\n                                </legend>\n                                <div class="form-group ">\n                                    <div class="col-md-2 ">\n                                        <label class="sr-only " for="sequenceRelPhenotypeMinDurationValue ">From</label>\n                                        <input type="number " class="form-control " name="sequenceRelPhenotypeMinDurationValue " id="sequenceRelPhenotypeMinDurationValue " placeholder="min " value=" " />\n                                    </div>\n                                    <div class="col-md-3 ">\n                                        <label class="sr-only " for="sequenceRelPhenotypeMinDurationUnits ">From units</label>\n                                        <select name="sequenceRelPhenotypeMinDurationUnits " class="form-control "></select>\n                                    </div>\n                                    <div class="col-md-1 control-label " style="text-align: center ">\n                                        <label for="sequenceRelPhenotypeMaxDurationValue ">to</label>\n                                    </div>\n                                    <div class="col-md-2 ">\n                                        <input type="number " class="form-control " name="sequenceRelPhenotypeMaxDurationValue " id="sequenceRelPhenotypeMaxDurationValue " placeholder="max " value=" " />\n                                    </div>\n                                    <div class="col-md-3 ">\n                                        <label class="sr-only " for="sequenceRelPhenotypeMaxDurationUnits ">To units</label>\n                                        <select name="sequenceRelPhenotypeMaxDurationUnits " class="form-control "></select>\n                                    </div>\n                                </div>\n                            </fieldset>\n                            <fieldset>\n                                <legend>\n                                    <input type="checkbox " class="checkbox-inline propertyValueConstraint " value="true " name="sequenceRelPhenotypeSpecifyProperty " /> Property value\n                                </legend>\n                                <div class="form-group ">\n                                    <div class="col-sm-6 ">\n                                        <label class="sr-only " for="sequenceRelPhenotypePropertyName ">Property name</label>\n                                        <select name="sequenceRelPhenotypePropertyName " class="form-control " id="sequenceRelPhenotypePropertyName ">\n                                                                                                \n                                                                                                </select>\n                                    </div>\n                                    <div class="col-sm-6 ">\n                                        <label class="sr-only " for="sequenceRelPhenotypePropertyValue ">Property value</label>\n                                        <input type="text " class="form-control propertyValueField " name="sequenceRelPhenotypePropertyValue " id="sequenceRelPhenotypePropertyValue " value=" " />\n                                    </div>\n                                </div>\n                            </fieldset>\n                            <fieldset>\n                                <legend>Temporal Relationship</legend>\n                                <div class="form-group ">\n                                    <div class="col-sm-6 ">\n                                        <label class="sr-only " for="sequenceRelPhenotypeTemporalRelation ">Temporal relation</label>\n                                        <select name="sequenceRelPhenotypeTemporalRelation " id="sequenceRelPhenotypeTemporalRelation " class="form-control ">\n                                                                                         \n                                                                                                </select>\n                                    </div>\n                                    <div class="col-sm-6 ">\n                                        <label class="sr-only " for="propositionSelect ">Other phenotype</label>\n                                        <select name="propositionSelect " class="form-control "></select>\n                                    </div>\n                                </div>\n                                <div class="form-group ">\n                                    <div class="col-md-1 control-label " style="text-align: center ">\n                                        <label for="sequenceRhsPhenotypeMinDistanceValue ">by</label>\n                                    </div>\n                                    <div class="col-md-2 ">\n                                        <input type="text " class="form-control " name="sequenceRhsPhenotypeMinDistanceValue " id="sequenceRhsPhenotypeMinDistanceValue " placeholder="min " value=" " />\n                                    </div>\n                                    <div class="col-md-3 ">\n                                        <label class="sr-only " for="sequenceRhsPhenotypeMinDistanceUnits ">By units</label>\n                                        <select name="sequenceRhsPhenotypeMinDistanceUnits " id="sequenceRhsPhenotypeMinDistanceUnits " class="form-control ">\n                                                                             \n                                                                                                </select>\n                                    </div>\n                                    <div class="col-md-1 control-label " style="text-align: center ">\n                                        <label for="sequenceRhsPhenotypeMaxDistanceValue ">to</label>\n                                    </div>\n                                    <div class="col-md-2 ">\n                                        <input type="text " class="form-control " placeholder="max " name="sequenceRhsPhenotypeMaxDistanceValue " id="sequenceRhsPhenotypeMaxDistanceValue " value=" " />\n                                    </div>\n                                    <div class=" col-md-3 ">\n                                        <label class="sr-only " for="sequenceRhsPhenotypeMaxDistanceUnits ">To units</label>\n                                        <select name="sequenceRhsPhenotypeMaxDistanceUnits " class="form-control "></select>\n                                    </div>\n                                </div>\n                            </fieldset>\n                        </div>\n                        <div class="form-group text-center vert-offset ">\n                            <button id="duplicateRelatedButton " type="button " class="btn btn-primary ">\n                                                <span class="glyphicon glyphicon-plus "></span> Add Related Phenotype\n                                        </button>\n                            <button id="savePhenotypeButton " type="button " class="btn btn-primary ">Save</button>\n                        </div>\n            </form>\n\n\n            </div>\n            </div>\n        </div>\n\n\n\n\n\n        <!--\n<div layout="column " layout-gt-md="row " >\n\n  <md-content flex flex-order="2 " flex-order-gt-md="1 " layout-padding>\n    <cohort-members-tree member-list="newCohort.memberList "></cohort-members-tree>\n  </md-content>\n\n  <md-content flex="60 " flex-gt-lg="66 " flex-order="1 " flex-order-gt-md="2 " layout-padding>\n    <form name="userForm ">\n      <md-card>\n        <md-card-content>\n          <h2 class="md-headline " style="margin-top: 0 ">New {{createPhenotype.type}} Phenotype</h2>\n          <p ng-bind="createPhenotype.description "></p>\n          <md-input-container flex>\n            <label>Name</label>\n            <input ng-model="createPhenotype.phenotype.name ">\n          </md-input-container>\n          <md-input-container flex>\n            <label>Description</label>\n            <textarea ng-model="createPhenotype.phenotype.description " columns="1 " md-maxlength="250 "></textarea>\n          </md-input-container>\n        </md-card-content>\n        <md-toolbar class="md-primary md-hue-1 ">\n          <div class="md-toolbar-tools ">\n            <h3 class="md-title ">\n              <span>Main Data Element</span>\n            </h3>\n          </div>\n        </md-toolbar>\n        <md-card-content>\n          <cohort-members-drop-zone member-list="createPhenotype.memberList "></cohort-members-drop-zone>\n\n          <div layout layout-sm="column " layout-align="center center ">\n            <md-checkbox ng-model="createPhenotype.duration.enabled " aria-label="Checkbox 1 ">\n              Duration\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Min</label>\n              <input type="number " step="any " name="minDuration " ng-model="createPhenotype.duration.min " />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration.minUnit ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <div style="padding:20px "><b>to</b></div>\n            <md-input-container flex>\n              <label>Max</label>\n              <input type="number " step="any " name="maxDuration " ng-model="createPhenotype.duration.max " />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration.maxUnit ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column " layout-align="center center ">\n            <md-checkbox ng-model="createPhenotype.property.enabled " aria-label="Checkbox 1 ">\n              Property Value\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Property</label>\n              <md-select ng-model="createPhenotype.property.name ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <md-input-container flex>\n              <label>Value</label>\n              <input type="number " step="any " name="propertyValue " ng-model="createPhenotype.property.value " />\n            </md-input-container>\n          </div>\n        </md-card-content>\n        <md-toolbar class="md-primary md-hue-1 ">\n          <div class="md-toolbar-tools ">\n            <h3 class="md-title ">\n              <span>Related Data Element 1</span>\n            </h3>\n          </div>\n        </md-toolbar>\n        <md-card-content>\n          <cohort-members-drop-zone member-list="createPhenotype.memberList "></cohort-members-drop-zone>\n\n          <div layout layout-sm="column " layout-align="center center ">\n            <md-checkbox ng-model="createPhenotype.duration1.enabled " aria-label="Checkbox 1 ">\n              Duration\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Min</label>\n              <input type="number " step="any " name="minDuration1 " ng-model="createPhenotype.duration1.min " />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.minUnit ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <div style="padding:20px "><b>to</b></div>\n            <md-input-container flex>\n              <label>Max</label>\n              <input type="number " step="any " name="maxDuration " ng-model="createPhenotype.duration1.max " />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.maxUnit ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column " layout-align="center center ">\n            <md-checkbox ng-model="createPhenotype.property1.enabled " aria-label="Checkbox 1 ">\n              Property Value\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Property</label>\n              <md-select ng-model="createPhenotype.property1.name ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <md-input-container flex>\n              <label>Value</label>\n              <input type="number " step="any " name="propertyValue1 " ng-model="createPhenotype.property1.value " />\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column " layout-align="center center ">\n            <div style="padding:10px ">\n              <b>Temporal Relationship</b>\n            </div>\n            <md-input-container flex>\n              <label>Order</label>\n              <md-select ng-model="createPhenotype.relationship.order ">\n                <md-option ng-repeat="order in [ \'before\', \'after\'] " value="{{order}} ">\n                  {{order}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <md-input-container flex>\n              <label>Element</label>\n              <md-select ng-model="createPhenotype.relationship.element ">\n                <md-option ng-repeat="element in [ \'main element\'] " value="{{element}} ">\n                  {{element}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column " layout-align="center center ">\n            <div style="padding:10px ">\n              <b>by</b>\n            </div>\n            <md-input-container flex>\n              <label>Min</label>\n              <input type="number " step="any " name="minDuration1 " ng-model="createPhenotype.duration1.min " />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.minUnit ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <div style="padding:20px "><b>to</b></div>\n            <md-input-container flex>\n              <label>Max</label>\n              <input type="number " step="any " name="maxDuration " ng-model="createPhenotype.duration1.max " />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.maxUnit ">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits " value="{{unit}} ">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n        </md-card-content>\n        <div class="md-actions md-padding " layout="row " layout-align="start center ">\n          <md-button class="md-raised md-primary md-hue-1 " ng-click="newCohort.submitCohortForm() "> Save </md-button>\n        </div>\n      </md-card>\n    </form>\n  </md-content>\n\n</div>  -->');$templateCache.put('eureka/phenotypes/views/edit/edit.html','<div class="row" ng-cloak>\n    <div class="col-sm-12">\n        <h3>{{editPhenotype.name}} Editor</h3>\n        <p>\n            {{editPhenotype.description}}\n        </p>\n    </div>\n</div>\n\n<div class="row">\n    <div class="col-md-12">\n    </div>\n</div>\n<div class="row">\n    <div class="col-md-12">\n        <div id="definitionContainer" class="col-md-8">\n            <form id="categorizationForm" class="vert-offset" role="form">\n                <div class="form-group">\n                    <label for="patCohortDefName" class="control-label">Name</label>\n                    <input type="text" id="patCohortDefName" class="form-control" ng-model="editPhenotype.destination.displayName" />\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDescription" class="control-label">Description</label>\n                    <textarea id="patCohortDescription" class="form-control" ng-model="editPhenotype.destination.description"></textarea>\n                </div>\n                <div class="form-group">\n                    <label for="patCohortDefinition" class="control-label">Members</label>\n\n                </div>\n\n                <div class="form-group text-center vert-offset">\n                    <button id="savePhenotypeButton" type="button" class="btn btn-primary">Save</button>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n\n<!--<div layout="column" layout-gt-md="row" >\n\n  <md-content flex flex-order="2" flex-order-gt-md="1" layout-padding>\n    <cohort-members-tree member-list="newCohort.memberList"></cohort-members-tree>\n  </md-content>\n\n  <md-content flex="60" flex-gt-lg="66" flex-order="1" flex-order-gt-md="2" layout-padding>\n    <form name="userForm">\n      <md-card>\n        <md-card-content>\n          <h2 class="md-headline" style="margin-top: 0">New {{createPhenotype.type}} Phenotype</h2>\n          <p ng-bind="createPhenotype.description"></p>\n          <md-input-container flex>\n            <label>Name</label>\n            <input ng-model="createPhenotype.phenotype.name">\n          </md-input-container>\n          <md-input-container flex>\n            <label>Description</label>\n            <textarea ng-model="createPhenotype.phenotype.description" columns="1" md-maxlength="250"></textarea>\n          </md-input-container>\n        </md-card-content>\n        <md-toolbar class="md-primary md-hue-1">\n          <div class="md-toolbar-tools">\n            <h3 class="md-title">\n              <span>Main Data Element</span>\n            </h3>\n          </div>\n        </md-toolbar>\n        <md-card-content>\n          <cohort-members-drop-zone member-list="createPhenotype.memberList"></cohort-members-drop-zone>\n\n          <div layout layout-sm="column" layout-align="center center">\n            <md-checkbox ng-model="createPhenotype.duration.enabled" aria-label="Checkbox 1">\n              Duration\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Min</label>\n              <input type="number" step="any" name="minDuration" ng-model="createPhenotype.duration.min" />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration.minUnit">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <div style="padding:20px"><b>to</b></div>\n            <md-input-container flex>\n              <label>Max</label>\n              <input type="number" step="any" name="maxDuration" ng-model="createPhenotype.duration.max" />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration.maxUnit">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column" layout-align="center center">\n            <md-checkbox ng-model="createPhenotype.property.enabled" aria-label="Checkbox 1">\n              Property Value\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Property</label>\n              <md-select ng-model="createPhenotype.property.name">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <md-input-container flex>\n              <label>Value</label>\n              <input type="number" step="any" name="propertyValue" ng-model="createPhenotype.property.value" />\n            </md-input-container>\n          </div>\n        </md-card-content>\n        <md-toolbar class="md-primary md-hue-1">\n          <div class="md-toolbar-tools">\n            <h3 class="md-title">\n              <span>Related Data Element 1</span>\n            </h3>\n          </div>\n        </md-toolbar>\n        <md-card-content>\n          <cohort-members-drop-zone member-list="createPhenotype.memberList"></cohort-members-drop-zone>\n\n          <div layout layout-sm="column" layout-align="center center">\n            <md-checkbox ng-model="createPhenotype.duration1.enabled" aria-label="Checkbox 1">\n              Duration\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Min</label>\n              <input type="number" step="any" name="minDuration1" ng-model="createPhenotype.duration1.min" />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.minUnit">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <div style="padding:20px"><b>to</b></div>\n            <md-input-container flex>\n              <label>Max</label>\n              <input type="number" step="any" name="maxDuration" ng-model="createPhenotype.duration1.max" />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.maxUnit">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column" layout-align="center center">\n            <md-checkbox ng-model="createPhenotype.property1.enabled" aria-label="Checkbox 1">\n              Property Value\n            </md-checkbox>\n            <md-input-container flex>\n              <label>Property</label>\n              <md-select ng-model="createPhenotype.property1.name">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <md-input-container flex>\n              <label>Value</label>\n              <input type="number" step="any" name="propertyValue1" ng-model="createPhenotype.property1.value" />\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column" layout-align="center center">\n            <div style="padding:10px">\n              <b>Temporal Relationship</b>\n            </div>\n            <md-input-container flex>\n              <label>Order</label>\n              <md-select ng-model="createPhenotype.relationship.order">\n                <md-option ng-repeat="order in [\'before\', \'after\']" value="{{order}}">\n                  {{order}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <md-input-container flex>\n              <label>Element</label>\n              <md-select ng-model="createPhenotype.relationship.element">\n                <md-option ng-repeat="element in [\'main element\']" value="{{element}}">\n                  {{element}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n\n          <div layout layout-sm="column" layout-align="center center">\n            <div style="padding:10px">\n              <b>by</b>\n            </div>\n            <md-input-container flex>\n              <label>Min</label>\n              <input type="number" step="any" name="minDuration1" ng-model="createPhenotype.duration1.min" />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.minUnit">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n            <div style="padding:20px"><b>to</b></div>\n            <md-input-container flex>\n              <label>Max</label>\n              <input type="number" step="any" name="maxDuration" ng-model="createPhenotype.duration1.max" />\n            </md-input-container>\n            <md-input-container flex>\n              <label>Unit</label>\n              <md-select ng-model="createPhenotype.duration1.maxUnit">\n                <md-option ng-repeat="unit in createPhenotype.timeUnits" value="{{unit}}">\n                  {{unit}}\n                </md-option>\n              </md-select>\n            </md-input-container>\n          </div>\n        </md-card-content>\n        <div class="md-actions md-padding" layout="row" layout-align="start center">\n          <md-button class="md-raised md-primary md-hue-1" ng-click="newCohort.submitCohortForm()"> Save </md-button>\n        </div>\n      </md-card>\n    </form>\n  </md-content>\n\n</div>  -->');$templateCache.put('eureka/phenotypes/views/main/main.html','\n<div class="row">\n  <div class="col-sm-12">\n    <h3>Phenotype Editor</h3>\n    <p> Specify the phenotypes that you want to compute in your datasets below. Phenotypes are patient features inferred from\n      sequence, frequency and other temporal patterns in the events and observations in your dataset. These features are\n      computed as intervals with a start time and a stop time representing when they are present.\n    </p>\n    <p>\n      <div class="btn-group" uib-dropdown keyboard-nav>\n        <button id="simple-btn-keyboard-nav" type="button" class="btn btn-primary" uib-dropdown-toggle>\n          <span class="glyphicon glyphicon-plus-sign"></span>\n            <span>Create New Element</span> \n            <span class="caret"></span>\n        </button>\n        <ul class="dropdown-menu" uib-dropdown-menu role="menu" aria-labelledby="simple-btn-keyboard-nav">\n            <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'categorization\')">{{phenotypes.messages.CATEGORIZATION.displayName}} <p>{{phenotypes.messages.CATEGORIZATION.description}}</p></a></li>\n            <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'sequence\')">{{phenotypes.messages.SEQUENCE.displayName}} <p>{{phenotypes.messages.SEQUENCE.description}}</p></a></li>\n            <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'frequency\')">{{phenotypes.messages.FREQUENCY.displayName}} <p>{{phenotypes.messages.FREQUENCY.description}}</p></a></li>\n            <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'value-threshold\')">{{phenotypes.messages.VALUE_THRESHOLD.displayName}} <p>{{phenotypes.messages.VALUE_THRESHOLD.description}}</p></a></li>\n            <li role="menuitem"><a ng-click="phenotypes.navigateTo(\'temporal\')">{{phenotypes.messages.TEMPORAL.displayName}} <p>{{phenotypes.messages.TEMPORAL.description}}</p></a></li>\n        </ul>\n    </div>\n    </p>\n  </div>\n</div>\n<!-- ng-table -->\n<div class="row">\n  <div class="col-md-12">\n    <table ng-table="phenotypes.tableParams" class="table" show-filter="true">\n      <tr ng-repeat="user in $data">\n        <td>\n          <a  title="Edit" ui-sref="editPhenotype({ id: user.key })">\n            <span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span>\n          </a>\n          <span class="glyphicon glyphicon-remove delete-icon"  ng-click="phenotypes.deletePhenotype(user, $index)" title="Delete"></span>\n        </td>\n        <td title="\'Name\'" filter="{ displayName: \'text\'}" sortable="\'displayName\'">\n          {{user.displayName}}\n        </td>\n        <td title="\'Description\'" filter="{ description: \'text\'}" sortable="\'description\'">\n          {{user.description}}\n        </td>\n        <td title="\'Type\'" filter="{ type: \'text\'}" sortable="\'type\'">\n          {{user.type}}\n        </td>\n        <td title="\'Created\'" filter="{ created: \'text\'}" sortable="\'created\'">\n          {{user.created | date:\'MM/dd/yyyy\'}}\n        </td>\n         <td title="\'lastModified\'" filter="{ lastModified: \'text\'}" sortable="\'lastModified\'">\n          {{user.lastModified | date:\'MM/dd/yyyy\'}}\n        </td>\n      </tr>\n    </table>\n  </div>\n</div>\n\n<script type="text/ng-template" id="myModal.html">\n    <div class="modal-header">\n        <h3 class="modal-title">Delete Element</h3>\n    </div>\n    <div class="modal-body">\n        Are you sure you would like to remove this item?\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-primary" ng-click="mo.ok()">Delete</button>\n        <button class="btn btn-primary" ng-click="mo.cancel()">Close</button>\n    </div>\n</script>\n\n<script type="text/ng-template" id="errorModal.html">\n    <div class="modal-header">\n        <h3 class="modal-title">Error</h3>\n    </div>\n    <div class="modal-body">\n       {{mod.data}}\n    </div>\n    <div class="modal-footer">\n        <button class="btn btn-primary" ng-click="mod.cancel()">Close</button>\n    </div>\n</script>\n\n\n\n<!--\n<div layout>\n  <md-content flex layout-padding>\n    <md-card>\n\n   \n      <md-data-table-toolbar ng-hide="phenotypes.selected.length || phenotypes.filter.show">\n        <h2 class="md-title">Phenotype Editor</h2>\n        <div flex></div>\n        <md-button class="md-icon-button" ng-click="phenotypes.filter.show = true">\n          <i class="material-icons md-dark">search</i>\n        </md-button>\n        <md-menu md-position-mode="target-right target">\n          <md-button class="md-icon-button" aria-label="Create a new element" ng-click="phenotypes.openMenu($mdOpenMenu, $event)">\n            <md-icon class="md-dark" md-menu-origin>add_circle</md-icon>\n          </md-button>\n          <md-menu-content width="4">\n            <md-menu-item ng-click="phenotypes.navigateTo(\'categorization\')">\n              <md-button>\n                <md-icon md-menu-align-target>view_module</md-icon>\n                Categorization\n              </md-button>\n            </md-menu-item>\n            <md-menu-item ng-click="phenotypes.navigateTo(\'sequence\')">\n              <md-button>\n                <md-icon>format_list_numbered</md-icon>\n                Sequence\n              </md-button>\n            </md-menu-item>\n            <md-menu-item ng-click="phenotypes.navigateTo(\'frequency\')">\n              <md-button>\n                <md-icon>blur_on</md-icon>\n                Frequency\n              </md-button>\n            </md-menu-item>\n            <md-menu-item ng-click="phenotypes.navigateTo(\'value-threshold\')">\n              <md-button>\n                <md-icon>thumbs_up_down</md-icon>\n                Value Threshold\n              </md-button>\n            </md-menu-item>\n          </md-menu-content>\n        </md-menu>\n        <md-button class="md-icon-button">\n          <i class="material-icons md-dark">help</i>\n          <md-tooltip>Phenotypes Help</md-tooltip>\n        </md-button>\n      </md-data-table-toolbar>\n\n      <md-data-table-toolbar ng-show="phenotypes.filter.show && !phenotypes.selected.length">\n        <i class="material-icons md-dark">search</i>\n        <form flex name="phenotypes.filter.form">\n          <input type="text" ng-model="phenotypes.query.filter" ng-model-options="phenotypes.filter.options" placeholder="Search...">\n        </form>\n        <md-button class="md-icon-button" ng-click="phenotypes.removeFilter()">\n          <i class="material-icons md-dark">close</i>\n        </md-button>\n      </md-data-table-toolbar>\n\n      <md-data-table-toolbar class="alternate" ng-show="phenotypes.selected.length" layout-align="space-between">\n        <div>{{phenotypes.selected.length}} {{phenotypes.selected.length > 1 ? \'items\' : \'item\'}} selected</div>\n        <div flex></div>\n        <md-button class="md-icon-button" ng-show="phenotypes.selected.length == 1" ui-sref="editPhenotype({ id: phenotypes.selected[0].id })">\n          <i class="material-icons md-dark">edit</i>\n        </md-button>\n        <md-button class="md-icon-button">\n          <i class="material-icons md-dark">delete</i>\n        </md-button>\n      </md-data-table-toolbar>\n\n      <md-card-content>\n        <p>\n          Specify the phenotypes that you want to compute in your datasets below. Phenotypes are patient features\n          inferred from sequence, frequency and other temporal patterns in the events and observations in your dataset.\n          These features are computed as intervals with a start time and a stop time representing when they are present.\n        </p>\n      </md-card-content>\n\n      <md-data-table-container>\n        <table md-data-table md-row-select="phenotypes.selected" md-progress="phenotypes.deferred">\n          <thead md-order="phenotypes.query.order" md-trigger="phenotypes.onOrderChange">\n          <tr>\n            <th name="Name" order-by="displayName"></th>\n            <th name="Description" order-by="description"></th>\n            <th name="Type" order-by="type"></th>\n            <th name="Created" unit="date" order-by="created"></th>\n            <th name="Last Modified" unit="date" order-by="lastModified"></th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr md-auto-select ng-repeat="prop in phenotypes.props">\n            <td>{{prop.displayName}}</td>\n            <td>{{prop.description}}</td>\n            <td>{{prop.type}}</td>\n            <td>{{prop.created | date:\'shortDate\'}}</td>\n            <td>{{prop.lastModified | date:\'shortDate\'}}</td>\n          </tr>\n          </tbody>\n        </table>\n      </md-data-table-container>\n\n      <md-data-table-pagination md-limit="phenotypes.query.limit" md-page="phenotypes.query.page" md-total="{{phenotypes.props.length}}" md-trigger="phenotypes.onPaginationChange"></md-data-table-pagination>\n     \n\n    </md-card>\n  </md-content>\n</div>    -->\n');}]);
'use strict';

(function () {

    'use strict';

    var eurekaModule = angular.module('eureka');

    eurekaModule.service('AppPropertiesService', ['$http', function ($http) {
        return {
            getAppProperties: function getAppProperties() {
                return $http.get('proxy-resource/appproperties/');
            }
        };
    }]);

    var appProperties = {
        dataEndpoint: 'proxy-resource',
        dataProtectedEndPoint: 'protected',
        filterEndpoint: 'protected/jstree3_searchsystemlist'
    };

    /**
     * @ngdoc object
     * @name eureka.appProperties
     * @description
     * Simple configuration object that stores application properties.
     */

    angular.module('eureka').value('appProperties', appProperties);
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc directive
     * @name eureka.directive:compareTo
     * @element *
     * @function
     * @description
     * compareTo directive
     */
    angular.module('eureka').directive('compareTo', compareTo);

    function compareTo() {
        return {
            require: 'ngModel',
            scope: {
                otherModelValue: '=compareTo'
            },
            link: function link(scope, element, attributes, ngModel) {

                ngModel.$validators.compareTo = function (modelValue) {
                    return modelValue === scope.otherModelValue;
                };

                scope.$watch('otherModelValue', function () {
                    ngModel.$validate();
                });
            }
        };
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc directive
     * @name eureka.directive:jstree
     * @element *
     * @function
     * @description
     * jstree wrapper directive
     * @requires eureka.listDragAndDropService
     */
    angular.module('eureka').directive('jstree', jstree);

    jstree.$inject = ['listDragAndDropService'];

    function jstree(listDragAndDropService) {

        return {
            scope: {
                data: '='
            },
            template: '<div id="filter">Tree did not load.</div>',
            restrict: 'E',
            controller: function controller($scope, $element, $attrs, $rootScope) {},
            link: function link(scope, element, attrs) {
                self.droppedElements = {};
                self.propId = null;
                self.propType = null;
                self.propSubType = null;
                var initData = null;
                var searchUpdateDivElem = attrs.searchUpdateDiv;
                var searchModalElem = attrs.searchModal;
                var searchValidationModalElem = attrs.searchValidationModal;
                var searchNoResultsModalElem = attrs.searchNoResultsModal;
                var treeCssUrl = attrs.treeCssUrl;

                $(element).jstree({
                    core: {
                        data: {
                            url: attrs.treeUrl,
                            dataType: 'json',
                            data: function data(n) {
                                return {
                                    key: n.id === '#' ? 'root' : n.id
                                };
                            }

                        }

                    },

                    plugins: ['themes', 'json_data', 'ui', 'crrm', 'dnd', 'search']
                });

                $(element).before($('<form id="search">' + '<span></span>' + '<div class="input-group"><input id="searchText" class="form-control" type="text" />' + '<div class="input-group-btn">' + '<input id="searchTree" class="btn btn-default" type=submit value="search" />' + '<input class="btn btn-default" type="reset" value="X" /></div></div>' + '</form>').bind({
                    reset: function reset(evt) {
                        $(element).jstree('clear_search');
                        $(element).jstree(true).settings.core.data = initData;
                        $(element).jstree(true).refresh();
                        $('#search span').html('');
                    },

                    submit: function submit(evt) {
                        $(element).jstree('clear_search');
                        var searchvalue = $('#search input[type="text"]').val();
                        initData = $(element).jstree(true).settings.core.data;
                        if (searchvalue !== '' && searchvalue.length >= 4) {
                            $(element).hide();
                            var $elem = $(searchUpdateDivElem);
                            $elem.text('Search is in progress. Please wait...');
                            $elem.show();

                            $(element).jstree('destroy');
                            $(element).jstree({
                                'core': {
                                    'data': {
                                        'url': function url(node) {
                                            return node.id === '#' ? attrs.treeSearch + '?str=' + searchvalue : attrs.treeUrl;
                                        },
                                        'dataType': 'json',
                                        'data': function data(node) {
                                            return {
                                                key: node.id === '#' ? 'root' : node.id

                                            };
                                        }
                                    }
                                },
                                'themes': {
                                    'name': 'default',
                                    'theme': 'default',
                                    'url': treeCssUrl
                                },
                                'plugins': ['themes', 'json_data', 'ui', 'crrm', 'dnd', 'search']
                            }).bind('loaded.jstree', function (e, data) {

                                if (data.instance._cnt === 0) {
                                    console.log('empty');
                                    var $elemNoResults = $(searchNoResultsModalElem);
                                    $elemNoResults.find('#searchContent').html('There are no entries in our\n                                            database that matched your search criteria.');
                                    $elemNoResults.modal('toggle');

                                    $elemNoResults.hide();
                                    $(element).jstree('clear_search');
                                    $(element).jstree(true).settings.core.data = initData;
                                    $(element).jstree(true).refresh();
                                    $('#searchText').val('');

                                    $(element).show();

                                    $elemNoResults = $(searchUpdateDivElem);
                                    $elemNoResults.hide();
                                } else if (data.instance._cnt > 200) {
                                    var $elemSearchModal = $(searchModalElem);
                                    $elemSearchModal.find('#searchContent').html('The number of search results\n                                                exceeded the maximum limit and all results might not be displayed.\n                                                Please give a more specific search query to see all results.');
                                    $elemSearchModal.modal('toggle');

                                    $elemSearchModal.hide();
                                    $(element).jstree('clear_search');
                                    $(element).jstree(true).settings.core.data = initData;
                                    $(element).jstree(true).refresh();
                                    $('#searchText').val('');

                                    $(element).show();

                                    $elemSearchModal = $(searchUpdateDivElem);
                                    $elemSearchModal.hide();
                                }
                            });

                            $elem.hide();
                            $(element).show();
                        } else if (searchvalue.length < 4) {
                            var $elemValidationModal = $(searchValidationModalElem);
                            $elemValidationModal.find('#searchContent').html('Please enter a search value with\n                                        length greater than 3.');
                            $elemValidationModal.modal('toggle');
                            $(element).show();
                        }
                        return false;
                    }

                }));

                $(document).on('dnd_move.vakata', function (e, data) {
                    var t = $(data.event.target);
                    if (!t.closest('.jstree').length) {
                        if (t.closest('.tree-drop').length) {
                            data.helper.find('.jstree-icon').removeClass('jstree-er').addClass('jstree-ok');
                        } else {
                            data.helper.find('.jstree-icon').removeClass('jstree-ok').addClass('jstree-er');
                        }
                    }
                });

                $(document).on('dnd_stop.vakata', function (e, data) {
                    self.dropFinishCallback(data);
                });

                self.attachClearModalHandlers = function () {
                    var deleteModal = $('#deleteModal');
                    if (deleteModal) {
                        var $deleteButton = $(deleteModal).find('#deleteButton');
                        $(deleteModal).on('hidden.bs.modal', function (e) {
                            $deleteButton.off('click');
                        });
                    }
                    var replaceModal = $('#replaceModal');
                    if (replaceModal) {
                        var $replaceButton = $(replaceModal).find('#replaceButton');
                        $(replaceModal).on('hidden.bs.modal', function (e) {
                            $replaceButton.off('click');
                        });
                    }
                };

                self.dropFinishCallback = function (data) {
                    var target = data.event.target;
                    // SBA
                    target = $(target).closest('#patCohortDefinition');
                    var textContent = data.data.origin.get_node(data.data.obj[0].id).original.text;

                    if (listDragAndDropService.idIsNotInList(target, data.data.obj[0].id)) {
                        var sortable = $(target).find('ul.sortable');
                        var elementKey = data.data.obj[0].id;
                        var newItem = $('<li></li>').attr('data-space', data.data.origin.get_node(elementKey).original.attr['data-space']).attr('data-desc', textContent).attr('data-type', data.data.origin.get_node(elementKey).original.attr['data-type']).attr('data-subtype', data.data.origin.get_node(elementKey).original.attr['data-subtype'] || '').attr('data-key', data.data.origin.get_node(elementKey).original.attr['data-proposition'] || data.data.origin.get_node(elementKey).original.attr['data-key']);

                        // check that all types in the categorization are the same
                        // SBA look here
                        if ($(sortable).data('drop-type') === 'multiple' && $(sortable).data('proptype') !== 'empty') {
                            if ($(sortable).data('proptype') !== $(newItem).data('type')) {
                                return;
                            }
                        } else {
                            var tmptype = $(newItem).data('type');
                            $(sortable).data('proptype', tmptype);
                        }

                        //this loop is executed only during replacement of a system element when droptype==single.
                        // In all other cases(adding element to multiple droptype lists, adding a new element to an
                        // empty list) the else statement is executed.
                        if ($(sortable).data('drop-type') === 'single' && $(sortable).find('li').length > 0) {
                            var $toRemove = $(sortable).find('li');
                            var dialog = $('#replaceModal');
                            $(dialog).find('#replaceContent').html('Are you sure you want to replace data element &quot;' + $toRemove.text().trim() + '&quot;?');
                            $(dialog).find('#replaceButton').on('click', function (e) {
                                listDragAndDropService.deleteItem($toRemove, $(sortable), 0);
                                listDragAndDropService.addNewItemToList(data, $(sortable), newItem);
                                $(dialog).modal('hide');
                            });
                            $(dialog).modal('show');
                        } else {
                            listDragAndDropService.addNewItemToList(data, sortable, newItem);
                        }
                    }
                };
            }
        };
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.dragAndDropService
     * @description
     * This is the list drag and drop service.
     */

    angular.module('eureka').factory('dragAndDropService', dragAndDropService);

    dragAndDropService.$inject = [];

    function dragAndDropService() {
        var currentNodes = [];
        return {
            setNodes: setNodes,
            getNodes: getNodes

        };

        function getNodes() {

            return currentNodes;
        }

        function setNodes(obj) {
            var currentList = currentNodes;
            var isDuplicate = false;
            //lets do it the long way first then we will refactor.  Lets see if there are duplicates JS
            if (currentList.length < 1) {
                currentNodes.push(obj);
            } else {
                for (var i = 0; i < currentList.length; i++) {
                    if (currentList[i].key === obj.key) {
                        isDuplicate = true;
                    }
                }
                if (isDuplicate !== true) {
                    currentNodes.push(obj);
                }
            }
        }
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.listDragAndDropService
     * @description
     * This is the list drag and drop service.
     */

    angular.module('eureka').factory('listDragAndDropService', listDragAndDropService);

    listDragAndDropService.$inject = [];

    function listDragAndDropService() {

        return {
            getIn: getIn,
            setIn: setIn,
            removeIn: removeIn,
            objSize: objSize,
            addDroppedElement: addDroppedElement,
            deleteElement: deleteElement,
            deleteItem: deleteItem,
            removeDroppedElement: removeDroppedElement,
            addNewItemToList: addNewItemToList,
            idIsNotInList: idIsNotInList,
            setPropositionSelects: setPropositionSelects,
            attachDeleteAction: attachDeleteAction

        };

        function getIn(obj, path) {
            var current = obj;
            for (var i = 0; i < path.length; i++) {
                current = current[path[i]];
                if (!current) {
                    break;
                }
            }
            return current;
        }

        function setIn(obj, path, value) {
            var current = obj;
            for (var i = 0; i < path.length - 1; i++) {
                var tmp = current[path[i]];
                if (!tmp) {
                    tmp = {};
                    current[path[i]] = tmp;
                }
                current = tmp;
            }
            current[path[path.length - 1]] = value;
        }

        function removeIn(obj, path) {
            var current = obj;
            for (var i = 0; i < path.length - 1; i++) {
                current = current[path[i]];
                if (current === null) {
                    break;
                }
            }
            delete current[path[path.length - 1]];
        }

        function objSize(obj) {
            var size = 0;
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    size++;
                }
            }
            return size;
        }

        function addDroppedElement(dropped, dropTarget) {
            var elementKey = $(dropped).data('key');
            var sourceId = $(dropTarget).data('count');
            var sourcePath = [self.propType, elementKey, 'sources', sourceId];
            var defPath = [self.propType, elementKey, 'definition'];
            var definition = getIn(self.droppedElements, defPath);

            setIn(self.droppedElements, sourcePath, dropTarget);
            if (!definition) {
                var properties = ['key', 'desc', 'type', 'subtype', 'space'];
                definition = {};
                $.each(properties, function (i, property) {
                    definition[property] = $(dropped).data(property);
                });
                setIn(self.droppedElements, defPath, definition);
            }

            var allSourcesPath = [self.propType, elementKey, 'sources'];
            var allSources = getIn(self.droppedElements, allSourcesPath);
            var size = objSize(allSources);
            if (size > 1) {
                for (var key in allSources) {
                    if (allSources.hasOwnProperty(key)) {
                        var source = allSources[key];
                        var items = $(source).find('li');
                        $(items).each(function (i, item) {
                            var span = $(item).find('span.desc');
                            var newText = $(dropped).data('desc') + ' [' + $(source).data('count') + ']';
                            $(span).text(newText);
                        });
                    }
                }
            }
        }

        function deleteElement(displayName, key) {
            var $dialog = $('<div></div>').html('Are you sure you want to delete cohort &quot;' + displayName.trim() + '&quot;? You cannot undo this action.').dialog({
                title: 'Delete Data Element',
                modal: true,
                resizable: false,
                buttons: {
                    'Delete': function Delete() {
                        $.ajax({
                            type: 'POST',
                            url: 'deletecohort?key=' + encodeURIComponent(key),
                            success: function success(data) {
                                $(this).dialog('close');
                                window.location.href = 'editorhome';
                            },
                            error: function error(data, statusCode) {
                                var $errorDialog = $('<div></div>').html(data.responseText).dialog({
                                    title: 'Error Deleting Data Element',
                                    buttons: {
                                        'OK': function OK() {
                                            $(this).dialog('close');
                                        }
                                    },
                                    close: function close() {
                                        $dialog.dialog('close');
                                    }
                                });
                                $errorDialog.dialog('open');
                            }
                        });
                    },
                    'Cancel': function Cancel() {
                        $(this).dialog('close');
                    }
                },
                close: function close() {
                    // do nothing here.
                }
            });
            $dialog.dialog('open');
        }

        function removeDroppedElement(removed, removeTarget) {
            var elementKey = $(removed).data('key');
            var sourceId = $(removeTarget).data('count');
            var path = [self.propType, elementKey, 'sources', sourceId];
            removeIn(self.droppedElements, path);

            var allSourcesPath = [self.propType, elementKey, 'sources'];
            var allSources = getIn(self.droppedElements, allSourcesPath);
            var size = objSize(allSources);
            if (size <= 1) {
                for (var key in allSources) {
                    if (allSources.hasOwnProperty(key)) {
                        var source = allSources[key];
                        var items = $(source).find('li');
                        $(items).each(function (i, item) {
                            var span = $(item).find('span.desc');
                            var newText = $(removed).data('desc');
                            $(span).text(newText);
                        });
                    }
                }
            }
        }

        function deleteItem(toRemove, sortable, replace) {
            var infoLabel = sortable.siblings('div.label-info');
            var target = sortable.parent();
            removeDroppedElement(toRemove, sortable);
            setPropositionSelects(sortable.closest('[data-definition-container="true"]'));
            toRemove.remove();
            if (sortable.find('li').length === 0 && replace === 0) {
                sortable.data('proptype', 'empty');
                infoLabel.show();
            }

            // remove the properties from the drop down
            $('select[data-properties-provider=' + $(target).attr('id') + ']').each(function (i, item) {
                $(item).empty();
            });
            //remove the disabled attribute to the property textbox if any.
            var parentTable = $(target).parent().parent().parent();
            var inputProperty = $(parentTable).find('input.propertyValueField');
            $(inputProperty).removeAttr('disabled');
            var inputPropertycheckbox = $(parentTable).find('input.propertyValueConstraint');
            $(inputPropertycheckbox).removeAttr('disabled');

            // perform any additional delete actions
            if (self.deleteActions && self.deleteActions[self.propType]) {
                self.deleteActions[self.propType]();
            }
        }

        function idIsNotInList(target, id) {
            var retVal = true;
            $(target).find('ul.sortable').find('li').each(function (i, item) {
                if ($(item).data('key') === id) {
                    retVal = false;
                }
            });
            return retVal;
        }

        function addNewItemToList(data, sortable, newItem) {
            var target = $(sortable).parent();

            $(target).find('div.label-info').hide();

            var X = $('<span></span>', {
                'class': 'glyphicon glyphicon-remove delete-icon',
                'data-action': 'remove'
            });

            attachDeleteAction(X);
            var textContent = data.data.origin.get_node(data.data.obj[0].id).original.text;

            newItem.append(X);
            newItem.append(textContent);

            sortable.append(newItem);

            // set the properties in the properties select
            if ($(data.data.obj[0]).data('properties')) {
                var properties = $(data.data.obj[0]).data('properties').split(',');
                $('select[data-properties-provider=' + $(target).attr('id') + ']').each(function (i, item) {
                    $(item).empty();
                    $(properties).each(function (j, property) {
                        $(item).append($('<option></option>').attr('value', property).text(property));
                    });
                });
            } else {
                var parent = $(target).closest('.form-group').parent();
                var inputProperty = $(parent).find('input.propertyValueField');
                $(inputProperty).attr('disabled', 'disabled');
                var inputPropertycheckbox = $(parent).find('input.propertyValueConstraint');
                $(inputPropertycheckbox).attr('disabled', 'disabled');
            }

            // add the newly dropped element to the set of dropped elements
            addDroppedElement(newItem, sortable);
            setPropositionSelects($(sortable).closest('[data-definition-container="true"]'));

            // finally, call any actions specific to the type of proposition being entered/edited
            if (self.dndActions && self.dndActions[self.propType]) {
                self.dndActions[self.propType](data.data.obj[0]);
            }
        }

        function setPropositionSelects(elem) {
            var droppedElems = self.droppedElements[self.propType];

            // this prevents an error in the inner loop which tries to
            // loop over this null object.
            if (droppedElems === null) {
                return;
            }

            var selects = $(elem).find('select[name="propositionSelect"]');
            $(selects).each(function (i, sel) {
                var $sortable = $(sel).closest('.drop-parent').find('ul.sortable');
                var originalSource = $(sel).data('sourceid');
                $(sel).attr('data-sourceid', '');
                $(sel).empty();
                $.each(droppedElems, function (elemKey, elemValue) {
                    var sources = droppedElems[elemKey]['sources'];
                    $.each(sources, function (sourceKey, sourceValue) {
                        var $items = $(sourceValue).find('li');
                        var selectedItem;
                        $items.each(function (i, item) {
                            if ($(item).data('key') === elemKey) {
                                selectedItem = item;
                            }
                            if (selectedItem && $sortable.data('count') !== $(sourceValue).data('count')) {
                                var sourceId = $(sourceValue).data('count');
                                var value = $(selectedItem).data('key') + '__' + sourceId;
                                var desc = $(selectedItem).data('desc');
                                if (self.objSize(sources) > 1) {
                                    desc += ' [' + sourceKey + ']';
                                }
                                var opt = $('<option></option>', {
                                    'value': value
                                }).text(desc);
                                if (value === $(selectedItem).data('key') + '__' + originalSource) {
                                    opt.attr('selected', 'selected');
                                }
                                $(sel).append(opt);
                            }
                        });
                    });
                });
            });
        }

        function attachDeleteAction(elem) {
            $(elem).each(function (i, item) {
                $(item).click(function () {
                    var $toRemove = $(item).closest('li');
                    var $sortable = $toRemove.closest('ul.sortable');
                    var dialog = $('#deleteModal');
                    $(dialog).find('#deleteContent').html('Are you sure you want to remove data element &quot;' + $toRemove.text().trim() + '&quot;?');
                    $(dialog).find('#deleteButton').on('click', function (e) {
                        deleteItem($toRemove, $sortable, 0);
                        $(dialog).modal('hide');
                    });
                    $(dialog).modal('show');
                });
            });
        }

        self.dndActions = {};
        self.deleteActions = {};
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.modals
     * @description
     * modal service.
     */

    angular.module('eureka').factory('modals', modals);

    modals.$inject = ['$modal'];

    function modals($modal) {

        return {
            getIn: getIn

        };

        function getIn(obj, path) {

            return current;
        }
    }
})();
/* globals self */
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.TreeService
     * @description
     * This will provide all services for tree component
     */

    angular.module('eureka').factory('TreeService', TreeService);

    TreeService.$inject = ['$http', '$q', 'appProperties'];

    function TreeService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;
        var dataProtectedEndPoint = appProperties.dataProtectedEndPoint;

        return {
            removePhenotype: removePhenotype,
            getPhenotype: getPhenotype,
            getTreeRoot: getTreeRoot,
            getTreeNode: getTreeNode,
            getUserListRoot: getUserListRoot
        };

        function getTreeRoot() {
            return $http.get(dataEndpoint + '/concepts').then(handleSuccess, handleError);
            // https://localhost:8443/eureka-webapp/protected/systemlist?key=root
            //https://localhost:8443/eureka-webapp/proxy-resource/systemlist?key=root
        }

        function getTreeNode(key) {
            if (key === 'root') {
                return $http.get(dataEndpoint + '/concepts/').then(handleSuccess, handleError);
            } else {
                return $http.get(dataEndpoint + '/concepts/' + key).then(handleSuccess, handleError);
                // https://localhost:8443/eureka-webapp/protected/systemlist?key=root
                //https://localhost:8443/eureka-webapp/proxy-resource/systemlist?key=root
            }
        }

        function getUserListRoot() {
            return $http.get(dataProtectedEndPoint + '/userproplist?key=root');
            //https://localhost:8443/eureka-webapp/protected/systemlist?key=root
        }

        function removePhenotype(id) {

            return $http['delete'](dataEndpoint + '/phenotypes/' + id).then(handleSuccess, handleError);
        }

        function getPhenotype(key) {
            return $http.get(dataEndpoint + '/phenotypes/' + key + '?summarize=true').then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

(function () {

    'use strict';

    /**
     * @ngdoc service
     * @name eureka.users
     * @description
     * This is the users service.
     * @requires $http
     * @requires $q
     * @requires eureka.appProperties
     */

    angular.module('eureka').factory('users', users);

    users.$inject = ['$http', '$q', 'appProperties'];

    var User = (function () {
        function User(info) {
            _classCallCheck(this, User);

            this.info = info;
        }

        _createClass(User, [{
            key: 'hasRole',
            value: function hasRole(name) {
                var roles = this.info.roles;

                return roles.some(function (role) {
                    return role.name === name;
                });
            }
        }, {
            key: 'getDisplayName',
            value: function getDisplayName() {
                var _info = this.info;
                var fullName = _info.fullName;
                var firstName = _info.firstName;
                var lastName = _info.lastName;
                var username = _info.username;

                if (fullName) {
                    return fullName;
                } else if (firstName || lastName) {
                    return [firstName, lastName].filter(function (val) {
                        return val && val.length > 0 ? val : undefined;
                    }).join(' ');
                } else {
                    return username;
                }
            }
        }]);

        return User;
    })();

    function users($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;

        return {
            getUser: getCurrentUser,
            getRole: getRole
        };

        function getRole(roleId) {
            return $http.get(dataEndpoint + '/roles/' + roleId).then(function (res) {
                return res.data;
            }, function (err) {
                console.error('role retrieval failed:', err);
                return err;
            });
        }

        function getCurrentUser() {
            return $http.get(dataEndpoint + '/users/me', {
                transformResponse: function transformResponse(data) {
                    try {
                        var jsonObject = JSON.parse(data); // verify that json is valid
                        return jsonObject;
                    } catch (e) {
                        console.log('User is not logged in!');
                    }
                }
            }).then(function (res) {
                var userInfo = res.data;
                if (!userInfo) {
                    return $q.when(null);
                }
                return $q.all(_.map(userInfo.roles, getRole)).then(function (roles) {
                    userInfo.roles = roles;
                    return new User(userInfo);
                });
            }, function (err) {
                console.error('error getting user:', err);
            });
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

var eurekaModule = angular.module('eureka');

eurekaModule.controller('NewsAndFundingController', ['$scope', '$sce', 'NewsAndFundingService', function ($scope, $sce, NewsAndFundingService) {
        var service = { versionHistory: [], supportedBy: [] };
        NewsAndFundingService.getVersionHistoryAsync().then(function (response) {
                $scope.versionHistory = response.data.versionHistory;
        });

        NewsAndFundingService.getSupportedByAsync().then(function (response) {
                var data = response.data;
                var result = data.supportedBy.slice(0, -1).join('; ');
                if (data.supportedBy.length > 1) {
                        result += '; and ';
                }
                result += data.supportedBy[data.supportedBy.length - 1];
                $scope.supportedByHTML = $sce.trustAsHtml(result);
        });
}]);
'use strict';

var eurekaModule = angular.module('eureka');

eurekaModule.service('NewsAndFundingService', ['$http', function ($http) {
    return {
        getVersionHistoryAsync: function getVersionHistoryAsync() {
            return $http.get('assets/data/version_history.json');
        },
        getSupportedByAsync: function getSupportedByAsync() {
            return $http.get('assets/data/supported_by.json');
        }
    };
}]);
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.cohorts.CohortFilterService
     * @description
     * This service provides an API to interact with the REST endpoint for cohorts.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.cohorts').factory('CohortFilterService', CohortFilterService);

    CohortFilterService.$inject = ['$http', '$q', 'appProperties'];

    function CohortFilterService($http, $q, appProperties) {

        return {
            filterCohorts: filterCohorts
        };

        function filterCohorts(filterString) {
            /* filter url looks like this: 
            https://localhost:8443/eureka-webapp/protected/jstree3_searchsystemlist?str=Patient&key=root 
            */
            return $http.get('' + appProperties.filterEndpoint, {
                cache: true,
                params: {
                    key: 'root',
                    str: filterString

                }
            }).then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }
        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.cohorts.CohortService
     * @description
     * This service provides an API to interact with the REST endpoint for cohorts.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.cohorts').factory('CohortService', CohortService);

    CohortService.$inject = ['$http', '$q', 'appProperties'];

    function CohortService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;

        return {
            getCohorts: getCohorts,
            getCohort: getCohort,
            getSystemElement: getSystemElement,
            getPhenotypes: getPhenotypes,
            removeCohort: removeCohort,
            createCohort: createCohort
        };

        function getCohorts() {

            var type = 'COHORT';
            return $http.get(dataEndpoint + '/destinations?type=' + type).then(handleSuccess, handleError);
        }

        function removeCohort(key) {

            return $http['delete'](dataEndpoint + '/destinations/' + key).then(handleSuccess, handleError);
        }

        function getSystemElement(key) {

            return $http.get(dataEndpoint + '/concepts/' + key + '?summary=true').then(handleSuccess, handleError);
        }
        function getCohort(cohortId) {
            return $http.get(dataEndpoint + '/destinations/' + cohortId).then(handleSuccess, handleError);
        }
        function getPhenotypes(cohort) {

            var cohorts = [];

            function traverse(node) {

                if (node.left_node !== undefined) {
                    traverse(node.left_node);
                }

                if (node.name !== undefined) {
                    cohorts.push(node.name);
                }

                if (node.right_node !== undefined) {
                    traverse(node.right_node);
                }
            }

            traverse(cohort.node);

            var promises = [];
            angular.forEach(cohorts, function (cohort) {
                var promise = $http.get(dataEndpoint + '/concepts/' + cohort + '?summary=true');
                promises.push(promise);
            });

            return $q.all(promises);
        }

        function createCohort(cohort) {
            /*This is what the data looks like being sent to server.  Does not look valid
            {"id":null,"type":"COHORT","ownerUserId":1,"name":"NameTest","description":"NameDescription",
            "phenotypeFields":null, "cohort":{"id":null,"node":{"id":null,"start":null,"finish":null,
            "type":"Literal","name":"\\ACT\\Medications\\"}},"read":false,"write":false,"execute":false,
            "created_at":null,"updated_at":null,"links":null}
            */
            var newCohort = {
                id: null,
                type: 'COHORT',
                ownerUserId: 1,
                phenotypeFields: null,
                cohort: {
                    id: null
                },
                read: false,
                write: false,
                execute: false,
                created_at: null,
                updated_at: null,
                links: null
            };
            var phenotypes = cohort.memberList;
            var node = { id: null, start: null, finish: null, type: 'Literal' };
            if (phenotypes.length === 1) {
                node.name = phenotypes[0].id;
            } else if (phenotypes.length > 1) {
                var first = true;
                var prev = null;
                for (var i = phenotypes.length - 1; i >= 0; i--) {
                    var literal = { id: null, start: null, finish: null, type: 'Literal' };
                    literal.name = phenotypes[i].id;
                    if (first) {
                        first = false;
                        prev = literal;
                    } else {
                        var binaryOperator = { id: null, type: 'BinaryOperator', op: 'OR' };
                        binaryOperator.left_node = literal;
                        binaryOperator.right_node = prev;
                        prev = binaryOperator;
                    }
                }
                node = prev;
            } else {
                node = null;
            }
            newCohort.name = cohort.name;
            newCohort.description = cohort.description;
            newCohort.cohort.id = null;
            newCohort.cohort.node = node;
            return $http.post(dataEndpoint + '/destinations/', newCohort).then(handleSuccess, handleError);
        }

        function handleSuccess(response) {
            return response.data;
        }
        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

(function () {
  'use strict';

  angular.module('eureka.cohorts').factory('CohortTreeService', CohortTreeService);

  CohortTreeService.$inject = ['$http', '$q', 'appProperties'];

  function CohortTreeService($http, $q, appProperties) {
    var dataEndpoint = appProperties.dataEndpoint;

    return {
      getTreeData: getTreeData
    };

    function getTreeData(id) {
      return $http.get(dataEndpoint + '/concepts/', {
        cache: true,
        params: {
          key: id
        }
      }).then(handleSuccess, handleError);
    }

    function handleSuccess(response) {
      return response.data;
    }

    function handleError(response) {
      if (!angular.isObject(response.data) && !response.data) {
        return $q.reject('An unknown error occurred.');
      }
      return $q.reject(response.data);
    }
  }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('CohortMembersDropZoneCtrl', CohortMembersDropZoneCtrl);

    CohortMembersDropZoneCtrl.$inject = [];

    function CohortMembersDropZoneCtrl() {
        var vm = this;

        vm.treeOptions = {
            accept: addMember
        };

        function nodeAllowed(node, memberList) {
            memberList = memberList || vm.memberList;
            if (memberList.indexOf(node) !== -1) {
                return false;
            }
            var differentType = vm.memberList.some(function (memberNode) {
                return node.type !== memberNode.type;
            });
            return !differentType;
        }

        function addMember(nodeScope, memberListScope) {
            var node = nodeScope.$modelValue;
            var memberList = memberListScope.$modelValue;
            return nodeAllowed(node, memberList);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('cohortMembersDropZone', CohortMembersDropZone);

    function CohortMembersDropZone() {
        return {
            restrict: 'E',
            bindToController: {
                memberList: '='
            },
            scope: {},
            replace: false,
            templateUrl: 'eureka/directives/cohort-members-drop-zone/cohort-members-drop-zone.html',
            controller: 'CohortMembersDropZoneCtrl',
            controllerAs: 'dropZone'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('CohortMembersTreeCtrl', CohortMembersTreeCtrl);

    CohortMembersTreeCtrl.$inject = ['CohortTreeService', 'CohortFilterService'];

    function CohortMembersTreeCtrl(CohortTreeService, CohortFilterService) {
        var vm = this;
        var getTreeData = CohortTreeService.getTreeData;
        var filterCohorts = CohortFilterService.filterCohorts;
        vm.toggleNode = toggleNode;
        vm.nodeAllowed = nodeAllowed;
        vm.filterCohortList = filterCohortList;
        vm.memberList = vm.memberList || [];

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        initTree();

        function initTree() {
            vm.loading = true;
            getTreeData('root').then(function (data) {
                console.log(data);
                vm.treeData = data;
                delete vm.loading;
            }, displayError);
        }

        function toggleNode(node) {
            if (!node.nodes) {
                node.loading = true;
                getTreeData(node.attr.id).then(function (data) {
                    console.log(data);
                    node.nodes = data;
                    delete node.loading;
                }, displayError);
            }
        }

        function nodeAllowed(node, memberList) {
            memberList = memberList || vm.memberList;
            if (memberList.indexOf(node) !== -1) {
                return false;
            }
            var differentType = vm.memberList.some(function (memberNode) {
                return node.type !== memberNode.type;
            });
            return !differentType;
        }

        function filterCohortList() {
            vm.loading = true;
            vm.treeData = [];
            filterCohorts(vm.treeSearch).then(function (data) {
                vm.treeData = data;
                delete vm.loading;
            }, displayError);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('cohortMembersTree', CohortMembersTree);

    function CohortMembersTree() {
        return {
            restrict: 'E',
            bindToController: {
                memberList: '='
            },
            scope: {},
            replace: false,
            templateUrl: 'eureka/directives/cohort-members-tree/cohort-members-tree.html',
            controller: 'CohortMembersTreeCtrl',
            controllerAs: 'tree'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').controller('GlobalGridCtrl', GlobalGridCtrl);

    GlobalGridCtrl.$inject = ['CohortTreeService', 'CohortFilterService'];

    function GlobalGridCtrl(CohortTreeService, CohortFilterService) {
        var vm = this;
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('globalGrid', GlobalGrid);

    function GlobalGrid() {
        return {
            restrict: 'E',
            //scope: true,
            templateUrl: 'eureka/directives/global-grid/global-grid.html',
            scope: {
                options: '@'
            },
            link: function link(scope, element, attrs) {

                scope.gridOptions = {
                    enableSorting: true,
                    paginationPageSizes: [10, 20, 30],
                    paginationPageSize: 10,
                    columnDefs: [],
                    data: []
                };
                scope.gridOptions.columnDefs = JSON.parse(attrs.gridOptions);
                scope.gridOptions.data = JSON.parse(attrs.gridData);
            }
        };
    }
})();
'use strict';

(function () {
    'use strict';

    angular.module('eureka').directive('tableDirectiveOne', TableDirectiveOne);

    function TableDirectiveOne() {
        return {
            restrict: 'EA',
            scope: true,
            link: function link(scope, element, attrs) {
                scope.tableData = scope.$eval(attrs.tableData);
                scope.tableParameters = scope.$eval(attrs.tableParameters);
            },
            templateUrl: 'eureka/directives/table-directive-one/table-directive-one.html'
        };
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.jobs.JobService
     * @description
     * This service provides an API to interact with the REST endpoint for jobs.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.jobs').factory('JobService', JobService);

    JobService.$inject = ['$http', '$q', 'appProperties'];

    function JobService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;

        return {
            fileUpload: fileUpload,
            getJobs: getJobs,
            getJob: getJob
        };

        function handleSuccess(response) {
            return response.data;
        }
        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }

        function fileUpload(sourceId) {

            return $http['post'](dataEndpoint + '/file/upload' + sourceId).then(handleSuccess, handleError);
        }

        function getJobs() {

            return $http['post'](dataEndpoint + '/jobs').then(handleSuccess, handleError);
        }

        function getJob(id) {

            return $http['post'](dataEndpoint + '/job/' + id).then(handleSuccess, handleError);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc service
     * @name eureka.phenotypes.PhenotypeService
     * @description
     * This service provides an API to interact with the REST endpoint for phenotypes.
     * @requires $http
     * @requires $q
     */

    angular.module('eureka.phenotypes').factory('PhenotypeService', PhenotypeService);

    PhenotypeService.$inject = ['$http', '$q', 'appProperties'];

    function PhenotypeService($http, $q, appProperties) {
        var dataEndpoint = appProperties.dataEndpoint;
        var dataProtectedEndPoint = appProperties.dataProtectedEndPoint;

        return {
            getSummarizedUserElements: getSummarizedUserElements,
            getPhenotypeMessages: getPhenotypeMessages
        };

        function getSummarizedUserElements() {
            return $http.get(dataEndpoint + '/phenotypes?summarize=true').then(handleSuccess, handleError);
        }

        function getPhenotypeMessages() {
            return {
                'CATEGORIZATION': {
                    'displayName': 'Categorization',
                    'description': 'For defining a significant category of codes or clinical events or observations.'
                },
                'TEMPORAL': {
                    'displayName': 'Temporal',
                    'description': 'For defining a disease, finding or patient care process to be reflected by codes\n                    ,clinical events and/or observations in a specified frequency, sequential or other temporal \n                    patterns.'
                },
                'SEQUENCE': {
                    'displayName': 'Sequence',
                    'description': 'For defining a disease, finding or patient care process to be reflected by codes,\n                    clinical events and/or observations in a specified sequential temporal pattern.'
                },
                'FREQUENCY': {
                    'displayName': 'Frequency',
                    'description': 'For defining a disease, finding or patient care process to be reflected by codes,\n                    clinical events and/or observations in a specified frequency.'
                },
                'VALUE_THRESHOLD': {
                    'displayName': 'Value Threshold',
                    'description': 'For defining clinically significant thresholds on the value of an observation.'
                }
            };
        }

        function handleSuccess(response) {
            return response.data;
        }

        function handleError(response) {
            if (!angular.isObject(response.data) && !response.data) {
                return $q.reject('An unknown error occurred.');
            }
            return $q.reject(response.data);
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:EditCtrl
     * @description
     * This is the edit controller for the cohorts section of the application.
     * @requires cohorts.CohortService
     * @requires $stateParams
     */

    angular.module('eureka.cohorts').controller('cohorts.EditCtrl', EditCtrl);

    EditCtrl.$inject = ['CohortService', '$stateParams'];

    function EditCtrl(CohortService, $stateParams) {
        var vm = this;

        if ($stateParams.key) {

            CohortService.getCohort($stateParams.key).then(function (data) {
                vm.destination = data;
                getPhenotypes(data);
            }, displayError);
        }

        function getPhenotypes(data) {
            CohortService.getPhenotypes(data.cohort).then(function (promises) {

                var phenotypes = [];
                for (var i = 0; i < promises.length; i++) {
                    phenotypes.push(new Object({
                        phenotypeKey: promises[i].data.key,
                        phenotypeDisplayName: promises[i].data.displayName,
                        type: 'SYSTEM'
                    }));
                }

                vm.destination.phenotypes = phenotypes;

                eureka.editor.setup(data.id !== null ? data.id : null, '#userTree', '#definitionContainer', '#savePropositionButton');
            });
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:MainCtrl
     * @description
     * This is the main controller for the cohorts section of the application.
     * @requires cohorts.CohortService
     */

    angular.module('eureka.cohorts').controller('cohorts.ModalCtrl', ModalCtrl).controller('cohorts.DeleteModalCtrl', DeleteModalCtrl).controller('cohorts.MainCtrl', MainCtrl);

    ModalCtrl.$inject = ['$uibModalInstance'];
    DeleteModalCtrl.$inject = ['$uibModalInstance', 'data'];
    MainCtrl.$inject = ['CohortService', 'NgTableParams', '$uibModal'];

    function ModalCtrl($uibModalInstance, currentUser) {
        var mo = this;
        mo.currentUser = currentUser;
        mo.ok = function () {
            $uibModalInstance.close();
        };

        mo.cancel = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }

    function DeleteModalCtrl($uibModalInstance, data) {
        var mo = this;
        mo.data = data;
        mo.ok = function () {
            $uibModalInstance.close();
        };

        mo.cancel = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }

    function MainCtrl(CohortService, NgTableParams, $uibModal) {
        var vm = this;
        var copyData = [];

        vm.remove = remove;
        vm.currentSelectedItem = {};

        function remove(key) {
            CohortService.removeCohort(key);
            vm.tableParams.filter({});
            for (var i = 0; i < vm.copyData.length; i++) {
                if (vm.copyData[i].name === key) {
                    vm.copyData.splice(i, 1);
                    break;
                }
            }
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        vm.selected = [];

        vm.filter = {
            options: {
                debounce: 500
            }
        };

        vm.query = {
            filter: '',
            order: 'name',
            limit: 5,
            page: 1
        };

        function success(cohorts) {
            vm.cohortsList = cohorts;
            vm.gridOptions.data = cohorts;
            vm.copyData = cohorts;
            // NG Table
            vm.tableParams = new NgTableParams({}, { dataset: vm.copyData });
        }

        vm.removeFilter = function () {
            vm.filter.show = false;
            vm.query.filter = '';

            if (vm.filter.form.$dirty) {
                vm.filter.form.$setPristine();
            }
        };

        vm.deleteCohort = function (user, indexOfRow) {
            var currentItem = user;
            var currentRow = indexOfRow;

            $uibModal.open({
                templateUrl: 'myModal.html',
                controller: 'cohorts.ModalCtrl',
                controllerAs: 'mo',
                resolve: {
                    currentUser: function currentUser() {
                        return user;
                    }
                }
            }).result.then(function () {
                removeCohort(currentItem);
            }, function (arg) {
                console.log(arg);
            });
        };

        function deleteSuccess() {
            vm.tableParams.filter({});
            for (var i = 0; i < vm.copyData.length; i++) {
                if (vm.copyData[i].name === vm.currentSelectedItem) {
                    vm.copyData.splice(i, 1);
                    break;
                }
            }
            vm.tableParams.reload();
        }

        function deleteError(_data) {
            $uibModal.open({
                templateUrl: 'errorModal.html',
                controller: 'phenotypes.DeleteModalCtrl',
                controllerAs: 'mod',
                resolve: {
                    data: function data() {
                        return _data;
                    }
                }
            }).result.then(function () {
                // nothing to do here
            }, function (arg) {
                // nothing to do here
            });
        }

        function removeCohort(data) {
            vm.currentSelectedItem = data;
            vm.deferred = CohortService.removeCohort(data).then(deleteSuccess, deleteError);
        }

        vm.onOrderChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        vm.onPaginationChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        // UI-Grid
        vm.gridOptions = {
            enableSorting: true,
            paginationPageSizes: [10, 20, 30],
            paginationPageSize: 10,
            columnDefs: [{
                name: ' ', field: 'edit',
                cellTemplate: '<a href="${editUrl}" title="Edit">' + '<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span></a> ' + '<span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>'
            }, { name: 'Name', field: 'name' }, { name: 'Descripton', field: 'description' }, { name: 'Type', field: 'type' }, { name: 'Created', field: 'created_at', enableCellEdit: false, cellFilter: 'date:"longDate"' }],
            data: []
        };

        CohortService.getCohorts().then(success, displayError);
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:NewCtrl
     * @description
     * This is the new controller for the cohorts section of the application.
     */

    angular.module('eureka.cohorts').controller('cohorts.NewCtrl', NewCtrl);

    NewCtrl.$inject = ['CohortService', '$state'];

    function NewCtrl(CohortService, $state) {
        var vm = this;
        var createCohort = CohortService.createCohort;

        vm.submitCohortForm = submitCohortForm;
        vm.memberList = [];

        function submitCohortForm() {
            var cohortObject = {};
            cohortObject.name = vm.cohort.name;
            cohortObject.description = vm.cohort.description;
            cohortObject.memberList = vm.memberList;

            createCohort(cohortObject).then(function (data) {
                // if successful we prob need to redirect back to the main table
                console.log('we made it back', data);
                $state.transitionTo('cohorts');
            }, displayError);
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.cohorts.controller:TestCtrk
     * @description
     * This is the test controller for the cohorts section of the application.
     * @requires cohorts.CohortService
     */

    angular.module('eureka.cohorts').controller('cohorts.TestCtrl', TestCtrl);

    TestCtrl.$inject = ['CohortService', 'NgTableParams'];

    function TestCtrl(CohortService, NgTableParams) {
        var vm = this;
        var copyData = [];
        vm.columnDefs = [{
            name: ' ', field: 'edit',
            cellTemplate: '<a href="${editUrl}" title="Edit">' + '<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span></a> ' + '<span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>'
        }, { name: 'Name', field: 'name' }, { name: 'Descripton', field: 'description' }, { name: 'Type', field: 'type' }, { name: 'Created', field: 'created_at', enableCellEdit: false, cellFilter: 'date:"longDate"' }];
        vm.testData = [{
            'name': 'Vital1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Vital2',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Vital3',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test2',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Patient Test',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Updated Patient',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Procedure Codes',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Procedure 12',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'ICD9',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'ICD10',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test ICD10',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test ICD9',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data Test',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }, {
            'name': 'Test1',
            'description': 'Description Data',
            'type': 'COHORT',
            'created_at': 1486327831997
        }];
        vm.remove = remove;

        function remove(key) {
            CohortService.removeCohort(key);
            for (var i = 0; i < vm.cohortsList.length; i++) {
                if (vm.cohortsList[i].name === key) {
                    vm.cohortsList.splice(i, 1);
                    break;
                }
            }
        }

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        vm.selected = [];

        vm.filter = {
            options: {
                debounce: 500
            }
        };

        vm.query = {
            filter: '',
            order: 'name',
            limit: 5,
            page: 1
        };

        function success(cohorts) {
            vm.cohortsList = cohorts;
            //using dummy data
            vm.gridOptions.data = vm.testData.concat(cohorts);
            copyData = vm.testData.concat(cohorts);
            // NG Table
            vm.tableParams = new NgTableParams({}, { dataset: copyData });
        }

        vm.removeFilter = function () {
            vm.filter.show = false;
            vm.query.filter = '';

            if (vm.filter.form.$dirty) {
                vm.filter.form.$setPristine();
            }
        };

        // in the future we may see a few built in alternate headers but in the mean time
        // you can implement your own search header and do something like
        vm.search = function (predicate) {
            vm.filter = predicate;
            vm.deferred = CohortService.getCohorts(vm.query).then(success, displayError);
        };

        vm.onOrderChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        vm.onPaginationChange = function () {
            return CohortService.getCohorts(vm.query);
        };

        // UI-Grid
        vm.gridOptions = {
            enableSorting: true,
            paginationPageSizes: [10, 20, 30],
            paginationPageSize: 10,
            columnDefs: [{ name: ' ', field: 'edit',
                cellTemplate: '<a href="${editUrl}" title="Edit">' + '<span class="glyphicon glyphicon-pencil edit-icon" title="Edit"></span></a> ' + '<span class="glyphicon glyphicon-remove delete-icon" title="Delete"></span>'
            }, { name: 'Name', field: 'name' }, { name: 'Descripton', field: 'description' }, { name: 'Type', field: 'type' }, { name: 'Created', field: 'created_at', enableCellEdit: false, cellFilter: 'date:"longDate"' }],
            data: []
        };

        CohortService.getCohorts().then(success, displayError);
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.jobs.controller:MainCtrl
     * @description
     * This is the main controller for the jobs section of the application.
     * @requires jobs.JobService
     */

    angular.module('eureka.jobs').controller('jobs.MainCtrl', MainCtrl);

    MainCtrl.$inject = ['JobService'];

    function MainCtrl(JobService) {
        var vm = this;

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        function success(cohorts) {
            vm.cohortsList = cohorts;
        }
        /*
        function getJobs(){
         }
         function uploadfile(){
            
        } */
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc directive
     * @name eureka.phenotypes.directive:phenotypeEditor
     * @element *
     * @function
     * @description
     * Phenotype editor directive.
     * @requires $http
     * @requires $templateCache
     * @requires $timeout
     * @requires eureka.listDragAndDropService
     */

    angular.module('eureka.phenotypes').directive('phenotypeEditor', phenotypeEditor);

    phenotypeEditor.$inject = ['$http', '$templateCache', '$timeout', 'listDragAndDropService'];

    function phenotypeEditor(http, templateCache, timer, listDragAndDropService) {

        return {
            scope: {
                item: '=phenotypeEditor'
            },
            replace: true,
            restrict: 'EA',
            templateUrl: 'eureka/phenotypes/directives/phenotype-editor/phenotype-editor.html',
            link: function link(scope, element, attrs, ctrl, transclude) {
                scope.$watch('$last', function (v) {
                    var editorAction = function editorAction() {

                        $('ul.sortable').each(function (i, list) {
                            $(list).find('li').each(function (j, item) {
                                listDragAndDropService.addDroppedElement(item, $(list));
                            });

                            $('span.delete-icon').each(function (i, item) {
                                $(item).click(function () {
                                    var $toRemove = $(item).closest('li');
                                    var $sortable = $toRemove.closest('ul.sortable');
                                    var dialog = $('#deleteModal');
                                    $(dialog).find('#deleteContent').html('Are you sure you want to remove ' + 'data element &quot;' + $toRemove.text().trim() + '&quot;?');
                                    $(dialog).find('#deleteButton').on('click', function (e) {
                                        listDragAndDropService.deleteItem($toRemove, $sortable, 0);
                                        $(dialog).modal('hide');
                                    });
                                    $(dialog).modal('show');
                                });
                            });
                        });
                        var parent = element.parent();
                        if (parent.is('div')) {
                            parent.append($('<ul></ul>').attr('data-drop-type', 'multiple').attr('data-proptype', 'empty').addClass('sortable').append(element.parent().children()));
                        }
                    };

                    timer(editorAction, 0);
                });
            }
        };
    }
})();
'use strict';

(function () {
    'use strict';

    /**
     * @ngdoc controller
     * @name eureka.phenotypes.controller:CreateCtrl
     * @description
     * This is the create controller for the phenotypes section of the application.
     * @requires $scope
     * @requires $location
     * @requires eureka.phenotypes.PhenotypeService
     */

    angular.module('eureka.phenotypes').controller('phenotypes.CreateCtrl', CreateCtrl);

    CreateCtrl.$inject = ['$stateParams', 'PhenotypeService', 'NgTableParams', 'dragAndDropService', 'TreeService'];

    function CreateCtrl($stateParams, PhenotypeService, NgTableParams, dragAndDropService, TreeService) {

        var vm = this;

        vm.breadCrumbs = [{ key: 'root', displayName: 'root' }];
        //start get tree list
        vm.currentMemeberList = [];
        getMemberList();

        TreeService.getTreeRoot().then(function (data) {
            //  vm.treeData = data;

            //vm.props = data;
            //copyData = data;
            // NG Table
            vm.tableParams = new NgTableParams({}, { dataset: data });

            callUserRoot();
        }, displayError);

        function callUserRoot() {
            TreeService.getUserListRoot().then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                vm.tableParamsUser = new NgTableParams({}, { dataset: data.data });
            }, displayError);
        }
        vm.selectNode = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            TreeService.getTreeNode(currentNode.key).then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                if (hasChildren) {
                    vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName, parent: currentNode.parent });
                }
                vm.tableParams = new NgTableParams({}, { dataset: data.children });
            }, displayError);
        };
        vm.addNode = function (node) {

            if (node) {
                dragAndDropService.setNodes(node);
            }
            getMemberList();
        };
        vm.removeNode = function (node) {
            for (var i = 0; i < vm.currentMemeberList.length; i++) {
                if (vm.currentMemeberList[i].key === node.key) {
                    vm.currentMemeberList.splice(i, 1);
                    break;
                }
            }
        };
        vm.setBreadCrumbs = function (node) {
            var currentNode = node;
            var hasChildren = node.parent;
            var pos = 0;
            var returnedData = [];

            TreeService.getTreeNode(currentNode.key).then(function (data) {
                //  vm.treeData = data;

                //vm.props = data;
                //copyData = data;
                // NG Table
                if (data.hasOwnProperty('parent') && data['parent']) {
                    returnedData = data.children;
                } else {
                    returnedData = data;
                }
                if (hasChildren) {
                    vm.breadCrumbs.push({ key: currentNode.key, displayName: currentNode.displayName });
                }

                vm.tableParams = new NgTableParams({}, { dataset: returnedData });

                pos = vm.breadCrumbs.map(function (e) {
                    return e.key;
                }).indexOf(currentNode.key);
                vm.breadCrumbs.length = pos + 1;
            }, displayError);
        };
        vm.type = _.startCase($stateParams.type);
        vm.timeUnits = ['minutes', 'hours', 'days'];

        switch ($stateParams.type) {
            case 'categorization':
                vm.description = 'This category data element may be used wherever its member data elements are accepted.';
                break;
            case 'sequence':
                vm.description = 'Computes intervals with the same start and stop time as the Main data element below when ' + 'the temporal relationships below are satisfied.';
                break;
            case 'frequency':
                vm.description = 'Computes an interval over the temporal extent of the intervals contributing to the ' + 'specified frequency count below.';
                break;
            case 'value-threshold':
                vm.description = 'Computes intervals corresponding to when the specified thresholds below are present.';
                break;
        }

        vm.openMenu = function ($mdOpenMenu, evt) {
            $mdOpenMenu(evt);
        };

        function displayError(msg) {
            vm.errorMsg = msg;
        }

        function getMemberList() {
            vm.currentMemeberList = dragAndDropService.getNodes();
        }
    }
})();
'use strict';

(function () {
  'use strict';

  /**
   * @ngdoc controller
   * @name eureka.phenotypes.controller:EditCtrl
   * @description
   * This is the edit controller for the phenotypes section of the application.
   * @requires $scope
   * @requires $location
   * @requires eureka.phenotypes.PhenotypeService
   */

  angular.module('eureka.phenotypes').controller('phenotypes.EditCtrl', EditCtrl);

  EditCtrl.$inject = ['$stateParams', 'PhenotypeService'];

  function EditCtrl($stateParams, PhenotypeService) {

    var vm = this;
    var currentType = '';

    if ($stateParams.id) {

      PhenotypeService.getPhenotype($stateParams.id).then(function (data) {
        vm.destination = data;
        currentType = data.type;
        setType();
        //getPhenotypes(data);
      }, displayError);
    }

    vm.type = _.startCase($stateParams.type);
    vm.timeUnits = ['minutes', 'hours', 'days'];
    function setType() {
      switch (currentType) {
        case 'CATEGORIZATION':
          vm.description = 'This category data element may be used wherever its member data elements are accepted.';
          vm.name = 'Categorization';
          break;
        case 'SEQUENCE':
          vm.description = 'Computes intervals with the same start and stop time as the Main data element below when ' + 'the temporal relationships below are satisfied.';
          vm.name = 'Sequence';
          break;
        case 'FREQUENCY':
          vm.description = 'Computes an interval over the temporal extent of the intervals contributing to the ' + 'specified frequency count below.';
          vm.name = 'Frequency';
          break;
        case 'VALUE_THRESHOLD':
          vm.description = 'Computes intervals corresponding to when the specified thresholds below are present.';
          vm.name = 'Value Threshold';
          break;
      }
    }
    vm.openMenu = function ($mdOpenMenu, evt) {
      $mdOpenMenu(evt);
    };

    function displayError(msg) {
      vm.errorMsg = msg;
    }
  }
})();
'use strict';

(function () {

  /**
   * @ngdoc controller
   * @name eureka.phenotypes.controller:MainCtrl
   * @description
   * This is the main controller for the phenotypes section of the application.
   * @requires $scope
   * @requires $location
   * @requires eureka.phenotypes.PhenotypeService
   */

  angular.module('eureka.phenotypes').controller('phenotypes.ModalCtrl', ModalCtrl).controller('phenotypes.DeleteModalCtrl', DeleteModalCtrl).controller('phenotypes.MainCtrl', MainCtrl);

  ModalCtrl.$inject = ['$uibModalInstance'];
  DeleteModalCtrl.$inject = ['$uibModalInstance', 'data'];
  MainCtrl.$inject = ['$state', 'PhenotypeService', 'NgTableParams', '$uibModal'];

  function ModalCtrl($uibModalInstance, currentUser) {
    var mo = this;
    mo.currentUser = currentUser;
    mo.ok = function () {
      $uibModalInstance.close();
    };

    mo.cancel = function () {
      $uibModalInstance.dismiss('cancel');
    };
  }

  function DeleteModalCtrl($uibModalInstance, data) {
    var mo = this;
    mo.data = data;
    mo.ok = function () {
      $uibModalInstance.close();
    };

    mo.cancel = function () {
      $uibModalInstance.dismiss('cancel');
    };
  }
  function MainCtrl($state, PhenotypeService, NgTableParams, $uibModal) {

    var vm = this;
    var copyData = [];

    vm.currentSelectedItem = {};
    vm.selected = [];

    vm.filter = {
      options: {
        debounce: 500
      }
    };

    vm.query = {
      filter: '',
      order: 'name',
      limit: 5,
      page: 1
    };

    function success(data) {
      vm.props = data;
      copyData = data;
      // NG Table
      vm.tableParams = new NgTableParams({}, { dataset: copyData });
    }

    function displayError(msg) {
      vm.errorMsg = msg;
    }

    vm.removeFilter = function () {
      vm.filter.show = false;
      vm.query.filter = '';

      if (vm.filter.form.$dirty) {
        vm.filter.form.$setPristine();
      }
    };

    vm.deletePhenotype = function (user, indexOfRow) {
      var currentItem = user;
      var currentRow = indexOfRow;

      $uibModal.open({
        templateUrl: 'myModal.html',
        controller: 'phenotypes.ModalCtrl',
        controllerAs: 'mo',
        resolve: {
          currentUser: function currentUser() {
            return user;
          }
        }
      }).result.then(function () {
        removePhenotype(currentItem);
      }, function (arg) {
        console.log(arg);
      });
    };

    function deleteSuccess() {
      vm.tableParams.filter({});
      for (var i = 0; i < vm.props.length; i++) {
        if (vm.props[i].displayName === vm.currentSelectedItem.displayName) {
          vm.props.splice(i, 1);
          break;
        }
      }
      vm.tableParams.reload();
    }

    function deleteError(_data) {
      $uibModal.open({
        templateUrl: 'errorModal.html',
        controller: 'phenotypes.DeleteModalCtrl',
        controllerAs: 'mod',
        resolve: {
          data: function data() {
            return _data;
          }
        }
      }).result.then(function () {}, function (arg) {});
    }

    function removePhenotype(data) {
      vm.currentSelectedItem = data;
      vm.deferred = PhenotypeService.removePhenotype(data.id).then(deleteSuccess, deleteError);
    }

    vm.onOrderChange = function () {
      return PhenotypeService.getSummarizedUserElements(vm.query);
    };

    vm.onPaginationChange = function () {
      return PhenotypeService.getSummarizedUserElements(vm.query);
    };

    PhenotypeService.getSummarizedUserElements().then(success, displayError);

    var messages = PhenotypeService.getPhenotypeMessages();
    vm.messages = messages;

    vm.openMenu = function ($mdOpenMenu, evt) {
      $mdOpenMenu(evt);
    };

    vm.navigateTo = function (phenotypeType) {
      $state.transitionTo('createPhenotype', {
        type: phenotypeType
      });
    };
  }
})();
//# sourceMappingURL=app-1b0c8813d7.js.map
