/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.cvrg.eureka.servlet;

import com.google.inject.Inject;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.user.client.EurekaClinicalUserProxyClient;
import org.eurekaclinical.user.client.comm.User;

public class LoginServlet
extends HttpServlet {
    private final EurekaClinicalUserProxyClient userClient;

    @Inject
    public LoginServlet(EurekaClinicalUserProxyClient inUserClient) {
        this.userClient = inUserClient;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            User user = (User)req.getAttribute("user");
            user.setLastLogin(new Date());
            this.userClient.updateUser(user, user.getId());
            resp.sendRedirect(req.getContextPath() + "/#/index");
        }
        catch (ClientException e) {
            ClientResponse.Status responseStatus = e.getResponseStatus();
            if (responseStatus == ClientResponse.Status.FORBIDDEN) {
                HttpSession session = req.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                resp.sendError(403);
            }
            throw new ServletException((Throwable)e);
        }
    }
}

